
#include <iostream>

#include "luaincl.h"
#include "lunar.h"
#include "script.h"

    class Account {
      lua_Number m_balance;
    public:
      static const char className[];
      static Lunar<Account>::RegType methods[];

      Account(lua_State *L)      { m_balance = luaL_checknumber(L, 1); }
      Account(double balance=0)    : m_balance(balance) { }
      int deposit (lua_State *L) { m_balance += luaL_checknumber(L, 1); return 0; }
      int withdraw(lua_State *L) { m_balance -= luaL_checknumber(L, 1); return 0; }
      int balance (lua_State *L) { lua_pushnumber(L, m_balance); return 1; }
      ~Account() { printf("deleted Account (%p)\n", this); }
    };

    const char Account::className[] = "Account";


    #define method(class, name) {#name, &class::name}

    Lunar<Account>::RegType Account::methods[] = {
      method(Account, deposit),
      method(Account, withdraw),
      method(Account, balance),
      {0,0}
    };


    class Object {
      public:
        static const char className[];
        static Lunar<Object>::RegType methods[];

        Object(lua_State* L) {callCount = 0; }
        Object(){callCount = 0;};
        ~Object() { printf("deleted Object (%p)\n", this); }


        int printName(lua_State* L)
        {
          callCount ++;
          printf("Hi i'm object %p ! This is the %i. call.\n",this,callCount);
          return 0;
        }


      private:
        int callCount;

    };

    const char Object::className[] = "Object";

    Lunar<Object>::RegType Object::methods[] = {
      method(Object, printName),
      {0,0}
    };

    int main(int argc, char *argv[])
    {
      Script script;

      // Register classes with the script
      Lunar<Account>::Register(&script);
      Lunar<Object>::Register(&script);

      Object* obj= new Object();
      Account a;
      Account *b = new Account(30);

      // Add instances to the script
      Lunar<Object>::insertObject(&script,obj,"Obj",true);
      Lunar<Account>::insertObject(&script,&a,"a",false);
      Lunar<Account>::insertObject(&script,b,"b",true);


      std::string file(argv[1]);

      if(script.loadFile(file))
        printf("File %s succefully loaded\n", file.c_str());

      //script.executeFile();

      std::string main("main");
      if( script.selectFunction(main,3))
       printf("function %s selected\n",main.c_str());

      script.pushParam(3.14159,main);
      script.executeFunction();

      float retf = script.getReturnedFloat();
      printf("main returned %f\n",retf);
      

      if(script.getReturnedBool())
       printf("main returned true\n");
      else
       printf("main returned false\n");

      int ret = script.getReturnedInt();
      printf("main returned %i\n",ret);
      
      //if(argc>1) lua_dofile(script.getLuaState(), argv[1]);

      return 0;
    }

