#ifndef __RESTORE_STACK_H__
#define __RESTORE_STACK_H__


#include "VirtualMachine.h"
/// Forward declaration
struct lua_State;

namespace OrxScript
{

  //! Class to restore the stack to the way we found it.
  class LuaRestoreStack
  {
  public:
    /**
     * @brief Stores the stack and the index to the top element
     *
     * @param virtualMachine the virtual machine to save
     */
    LuaRestoreStack (LuaVirtualMachine& virtualMachine);
    virtual ~LuaRestoreStack (void);

  protected:
    lua_State* savedState;
    int savedTopIndex;
  };

}

#endif // __RESTORE_STACK_H__
