/*
	orxonox - the future of 3D-vertical-scrollers

	Copyright (C) 2004 orx

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.

### File Specific:
	main-programmer: hdavid, amaechler
*/

// TODO: Vektortextur erzeugen und Regionen auswählen, Sky...

#include "cloud_effect.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

#include "glincl.h"
//#include "graphics_engine.h"
#include "material.h"
#include <math.h>

#include "parser/tinyxml/tinyxml.h"

using namespace std;

CREATE_FACTORY(CloudEffect, CL_CLOUD_EFFECT);

CloudEffect::CloudEffect(const TiXmlElement* root)
{
	this->setClassID(CL_CLOUD_EFFECT, "CloudEffect");

	this->init();

	if (root != NULL)
		this->loadParams(root);

	this->activate();
}

CloudEffect::~CloudEffect()
{
	this->deactivate();
}

void CloudEffect::loadParams(const TiXmlElement* root)
{
	WeatherEffect::loadParams(root);

	LoadParam(root, "animSpeed", this, CloudEffect, setCloudAnimation);

}


bool CloudEffect::init()
{
	// default values
	this->cloudAnimTimeStep = 0;

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);

	glGenTextures(2, &texID[0]);

	// Generate noise map a
	//CloudEffect::genNoiseMap(cloudMap32_a);
	
	if (this->cloudAnimTimeStep > 0) {
		// Generate noise map b
		//CloudEffect::genNoiseMap(cloudMap32_b);
	}

  this->material = new Material();

}

bool CloudEffect::activate()
{
	PRINTF(0)( "Activating CloudEffect\n");


}

bool CloudEffect::deactivate()
{
	PRINTF(0)("Deactivating CloudEffect\n");
}

void CloudEffect::draw() const
{
	/* TODO:
		-Load a texture, for now from an existing image, a cloud texture
		-Blend / Overlay this with a blue sky like in the tutorial
		-Make a skybox or whatever....
		-Animate it (for now move it along the sky)
	*/

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  this->material->setDiffuseMap("maps/lightning_bolt.png");
  this->material->select();

	glPushMatrix();
 	glEnable(GL_TEXTURE_2D);

 	glBindTexture(GL_TEXTURE_2D, texID[0]);

	// FIXME : Bind this to the sky - how do I do this?
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, 0.0f);
		glVertex3f(20, 20,  60);	// Bottom Left Of The Texture and Quad

		glTexCoord2f(1.0f, 0.0f);
		glVertex3f(60, 20,  60);	// Bottom Right Of The Texture and Quad

		glTexCoord2f(1.0f, 1.0f);
		glVertex3f(60, 60,  60);	// Top Right Of The Texture and Quad

		glTexCoord2f(0.0f, 1.0f);
		glVertex3f(20, 60,  60);	// Top Left Of The Texture and Quad
	glEnd(); 

	glPopMatrix();
}

void CloudEffect::tick (float dt)
{
	
}
