/*!
 * @file sound_source.h
 * @brief Definition of the SoundSource.
*/

#ifndef _SOUND_SOURCE_H
#define _SOUND_SOURCE_H

#include "base_object.h"
#include "alincl.h"

// FORWARD DECLARATION
class PNode;
namespace OrxSound
{
  class SoundBuffer;
  //! A class that represents a SoundSource
  class SoundSource : public BaseObject
  {
  public:
    SoundSource(const PNode* sourceNode = NULL, const SoundBuffer* buffer = NULL);
    SoundSource(const SoundSource& source);
    SoundSource& operator=(const SoundSource& source);
    bool operator==(const SoundSource& source);

    virtual ~SoundSource();

    // user interaction
    void play();
    void play(const SoundBuffer* buffer);
    void play(const SoundBuffer* buffer, float gain);
    void loop();
    void loop(const SoundBuffer* buffer);
    void loop(const SoundBuffer* buffer, float gain);
    void stop();
    void pause();
    void rewind();

    // development functions
    /** @returns The ID of this Source */
    inline ALuint getID() const { return this->sourceID; };
    /** @returns true, if the Source is Playing */
    inline bool   isPlaying() const { return this->bPlay; };
    void setSourceNode(const PNode* sourceNode);
    /** @returns the SoundBuffer of this Source */
    inline const SoundBuffer* getBuffer() const { return this->buffer; };
    /** @returns the SourceNode of this Source */
    inline const PNode* getNode() const { return this->sourceNode; };
    /** @param resident if the Source is Resident */
    inline void setResident(bool resident) { this->resident = resident; };
    /** @returns true if the alSource is Resident */
    inline bool isResident() const { return this->resident; };

    void setRolloffFactor(ALfloat rolloffFactor);

    static void resetSource(ALuint sourceID);

  private:
    bool retrieveSource();

  private:
    bool                   bPlay;                 //!< If the Source is Playing.
    bool                   resident;              //!< If the alSource should be resident (if true, the alSource will be returned on deletion).
    ALuint                 sourceID;              //!< The ID of the Source
    const SoundBuffer*     buffer;                //!< The buffer to play in this source.
    const PNode*           sourceNode;            //!< The SourceNode representing the position/velocity... of this source.
  };
}
#endif /* _SOUND_SOURCE_H */
