/*!
 * @file executor.h
 * Definition of a on-screen-shell
 */

#ifndef _EXECUTOR_SPECIALS_H
#define _EXECUTOR_SPECIALS_H

#include "executor.h"
#include "compiler.h"

#include "luaincl.h"



template<typename type> type fromLua(lua_state* state) { PRINTF(1)("NOT IMPLEMENTED\n"); };
template<> bool fromLua<bool>(lua_state* state);
template<> int fromLua<int>(lua_state* state);
template<> unsigned int fromLua<unsigned int>(lua_state* state);
template<> float fromLua<float>(lua_state* state);
template<> char fromLua<char>(lua_state* state);
template<> const std::string& fromLua<const std::string&>(lua_state* state);

// FORWARD DECLARATION


///////////
//// 0 ////
///////////
//! Executes a Function with a lua_state* parameter.
template<class T> class ExecutorLua0 : public Executor
{
public:
  /**
   * @brief Constructor of a ExecutorXML
   * @param function a Function to call
   */
  ExecutorLua0(void(T::*function)())
      : Executor()
  {
    this->functionPointer = function;
    this->functorType = Executor_Objective | Executor_NoLoadString;
  }

  /**
   * @brief executes the Command on BaseObject
   * @param object the BaseObject to execute this Executor on
   * @param loadString ignored in this case
   */
  virtual void operator()(BaseObject* object, const SubString& = SubString()) const
  {
    PRINTF(1)("no usefull executor\n");
  }

  virtual void operator()(BaseObject* object, unsigned int count, void* values) const
  {
    (dynamic_cast<T*>(object)->*(functionPointer))();
  }

  /**
   * @returns a _new_ Copy of this Executor
   */
  virtual Executor* clone () const
  {
    return = new ExecutorLua0<T>(ExecutorLua0<T>(this->functionPointer));
  }
};



///////////
//// 1 ////
///////////
//! Executes a Function with a lua_state* parameter.
template<class T, typename type0> class ExecutorLua1 : public Executor
{
  public:
  /**
   * @brief Constructor of a ExecutorXML
   * @param function a Function to call
   */
    ExecutorLua0(void(T::*function)(type0))
  : Executor(ExecutorParamType<type0>())
    {
      this->functionPointer = function;
      this->functorType = Executor_Objective | Executor_NoLoadString;
    }

  /**
     * @brief executes the Command on BaseObject
     * @param object the BaseObject to execute this Executor on
     * @param loadString ignored in this case
   */
    virtual void operator()(BaseObject* object, const SubString& = SubString()) const
    {
      PRINTF(1)("no usefull executor\n");
    }

    virtual void operator()(BaseObject* object, unsigned int count, void* values) const
    {
      lua_state* state = (lua_state*)values;
      type0 value0 = lua_pop values

      (dynamic_cast<T*>(object)->*(functionPointer))();
    }

  /**
     * @returns a _new_ Copy of this Executor
   */
    virtual Executor* clone () const
    {
      return = new ExecutorLua0<T>(ExecutorLua0<T>(this->functionPointer));
    }
};


#endif /* _EXECUTOR_SPECIALS_H */
