/*!
 * @file executor.h
 * Definition of a on-screen-shell
 */

#ifndef _EXECUTOR_SPECIALS_H
#define _EXECUTOR_SPECIALS_H

#include "executor.h"
#include "compiler.h"

#include "compiler.h"
#include "parser/tinyxml/tinyxml.h"
// FORWARD DECLARATION

//! Executes a Function with a const TiXmlElement* parameter.
/**
 * This is a Special Executor, that finds ParamName in root as XML-sub-element
 * This is especially usefull, if you have to Load a SubElement from root in a new Function
 * What must be defined is a XML-root to search the ParameterName under an  a Function to call.
 */
template<class T> class ExecutorXML : public Executor
{
  public:
    /**
   * @brief Constructor of a ExecutorXML
     * @param function a Function to call
     * @param root The XML root to search paramName under
     * @param paramName the ParameterName the search in root, and lookup the TiXmlElement from
     */
    ExecutorXML(void(T::*function)(const TiXmlElement*), const TiXmlElement* root, const char* paramName)
      : Executor(MT_EXT1)
    {
      PRINTF(4)("Loading %s from XML-element %p\n", paramName, root);

      if (likely(root != NULL && paramName != NULL))
        this->element = root->FirstChildElement(paramName);
      else
        this->element = NULL;

      this->functionPointer = function;
      this->functorType = Executor_Objective | Executor_NoLoadString;
    }

    /**
     * @brief clones an ExecutorXML, used to copy this Element.
     * @returns a _new_ Copy of this Executor
     */
    virtual Executor* clone () const
    {
      ExecutorXML<T>* executor = new ExecutorXML<T>();
      this->cloning(executor);
      executor->functionPointer = this->functionPointer;
      executor->element = this->element;
      return executor;
    }

    /**
     * @brief executes the Command on BaseObject
     * @param object the BaseObject to execute this Executor on
     * @param loadString ignored in this case
     */
    virtual void operator()(BaseObject* object, const SubString& = SubString()) const
    {
      if (object != NULL && this->element != NULL)
        (dynamic_cast<T*>(object)->*(functionPointer))(this->element);
    }

    virtual void operator()(BaseObject* object, unsigned int count, void* values) const
    {
      PRINTF(1)("missuse of XML-operator, OR IMPLEMENT.\n");
    }

  private:
    /**
   * @brief used for the copy-(Clone)-constructor
     */
    ExecutorXML() : Executor() { };


  private:
    void    (T::*functionPointer)(const TiXmlElement*);  //!< The functionPointer to the function to be called
    const   TiXmlElement* element;                       //!< The XML-element to call.
};

#endif /* _EXECUTOR_SPECIALS_H */
