#ifndef _SCRIPT_H
#define _SCRIPT_H


#include <string>
#include "base_object.h"

#include "luaincl.h"


class Script
{
  public:
    Script();
    ~Script();

    bool loadFile(std::string& filename);
    bool executeFile();

    lua_State* getLuaState() const{return luaState;}

    bool selectFunction(std::string& functionName, int retCount);
    bool executeFunction();
    bool pushParam(int param, std::string& toFunction);//overload this function to add different types
    bool pushParam(float param, std::string& toFunction);
    bool pushParam(double param, std::string& toFunction);




  private:

    int reportError(int error);

    lua_State*         luaState;         //!< The lua_State that the Script works on
    std::string        currentFile;      //!< The file that is loaded in the script
    std::string        currentFunction;  //!< The name of the current active function (the one that gets the pushed parameter)
    int                argumentCount;    //!< Number of arguments for the current function
    int                returnCount;      //!< Number of return values of the current function




};
#endif /* _SCRIPT_H */
