#include "Script.h"


Script::Script()
{
  returnCount = argumentCount = 0;

  luaState = lua_open();

  luaopen_base(luaState);
  luaopen_table(luaState);
  luaopen_io(luaState);
  luaopen_string(luaState);
  luaopen_math(luaState);
  luaopen_debug(luaState);

}


Script::~Script()
{
  lua_setgcthreshold(luaState, 0);  // collected garbage
  lua_close(luaState);
}


bool Script::loadFile(std::string& filename)
 {

   if(currentFile.length() != 0)
     printf("Could not load %s because an other file is already loaded: %s\n",filename.c_str(), currentFile.c_str());

   int error = luaL_loadfile (luaState, filename.c_str());

   if(error == 0)
   {
     error = lua_pcall(luaState, 0, 0, 0);

     if(error == 0)
     {
      currentFile = filename;
      return true;
     }
     else
     {
      reportError(error);
     }

   }
   else
   {
     reportError(error);
   }

   return false;
 }

 bool Script::executeFile()
 {
   if(currentFile.length() != 0)
   {
    int error = lua_pcall(luaState, 0, 0, 0);
    if( error == 0)
      return true;
     else
      {
       reportError(error);
       return false;
      }
   }
   return false;
 }

 bool Script::selectFunction(std::string& functionName, int retCount)
 {

   returnCount = retCount;
   argumentCount = 0;
   currentFunction = functionName;
   lua_pushlstring(luaState, currentFunction.c_str(), currentFunction.size() );
   lua_gettable(luaState, LUA_GLOBALSINDEX);

  /* if(lua_isfunction( luaState , -1))
   {
     return true;
   }
   else
   return false;*/
   return true;
 }

 //return number of returned values
 bool Script::executeFunction()
 {
   if(currentFunction.length() != 0 )
   {
    int error = lua_pcall(luaState, argumentCount, returnCount,0);
    if(error != 0)
    {
     reportError(error);
     return false;
    }
    else
    {
      currentFunction.assign("");//a function gets unusable after beeing called for the first time
      returnCount = argumentCount = 0;
      return true;
    }
   }
   else
     printf("Error: no function selected.\n");
 }


 //overload this function to add different types
 bool Script::pushParam(int param, std::string& toFunction)
 {
   if(currentFunction.compare(toFunction) == 0)
   {
     lua_pushnumber(luaState, (lua_Number) param);
     argumentCount++;
    return true;
   }
   else
   {
    printf("Couldn't add parameter because the wrong function is selected: %s instead of %s\n", currentFunction.c_str(), toFunction.c_str());
    return false;
   }

 }


 bool Script::pushParam(float param, std::string& toFunction)
 {
   if(currentFunction.compare(toFunction) == 0)
   {
     lua_pushnumber(luaState,(lua_Number) param);
     argumentCount++;
     return true;
   }
   else
   {
     printf("Couldn't add parameter because the wrong function is selected: %s instead of %s\n", currentFunction.c_str(), toFunction.c_str());
     return false;
   }

 }

 bool Script::pushParam(double param, std::string& toFunction)
 {
   if(currentFunction.compare(toFunction) == 0)
   {
     lua_pushnumber(luaState,(lua_Number) param);
     argumentCount++;
     return true;
   }
   else
   {
     printf("Couldn't add parameter because the wrong function is selected: %s instead of %s\n", currentFunction.c_str(), toFunction.c_str());
     return false;
   }

 }

 int Script::reportError(int error)
 {
 const char *msg = lua_tostring(luaState, -1);
 if (msg == NULL) msg = "(error with no message)";
 fprintf(stderr, "ERROR: %s\n", msg);
 lua_pop(luaState, 1);
 return error;
 }

