/*!
 * @file glgui_pushbutton.h
 * The gl_pushbutton widget of th openglGUI
 *
 */

#ifndef _GLGUI_PUSHBUTTON_H
#define _GLGUI_PUSHBUTTON_H

#include "glgui_button.h"

namespace OrxGui
{

  // FORWARD DECLARATION

  //! This is part of the openglGUI class
  /**
   *
   */
  class GLGuiPushButton : public GLGuiButton
  {

  public:
    GLGuiPushButton(const std::string& label = "");
    virtual ~GLGuiPushButton();




    virtual void draw() const;
    virtual void update();
  protected:
    virtual void resize();
    virtual void clicking(const Vector2D& pos);
    virtual void releasing(const Vector2D& pos);
    virtual void receivedFocus();
    virtual void removedFocus();



  private:
    void init();

  };
}
#endif /* _GLGUI_PUSHBUTTON_H */
