/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_pushbutton.h"

#include "text.h"
#include "material.h"

namespace OrxGui
{

  /**
   * @brief standard constructor
   */
  GLGuiPushButton::GLGuiPushButton (const std::string& label)
  : GLGuiButton(label)
  {
    this->init();

    this->resize();
  }


  /**
   * @brief standard deconstructor
  */
  GLGuiPushButton::~GLGuiPushButton()
  {
  }

  void GLGuiPushButton::resize()
  {
    this->label.setRelCoor2D(5, 5);
    this->setSize2D(this->label.getSizeX2D() + 10, this->label.getSizeY2D() + 10);

    GLGuiWidget::resize();
    this->frontRect().setTopLeft(1, 1);
    this->frontRect().setSize(this->getSizeX2D() -2, this->getSizeY2D() -2);
  }

  /**
   * initializes the GUI-element
   */
  void GLGuiPushButton::init()
  {
    this->setClassID(CL_GLGUI_PUSHBUTTON, "GLGuiPushButton");
  }

  void GLGuiPushButton::receivedFocus()
  {
    printf("%s received focus\n", this->getLabel().c_str());
    GLGuiWidget::receivedFocus();
  }

  void GLGuiPushButton::removedFocus()
  {
    printf("%s removed focus\n", this->getLabel().c_str());
    GLGuiWidget::removedFocus();

  }

  void GLGuiPushButton::clicking(const Vector2D& pos)
  {
    printf("%s clicked\n", this->getLabel().c_str());
    GLGuiButton::clicking(pos);
  }


  void GLGuiPushButton::releasing(const Vector2D& pos)
  {
    printf("%s released\n", this->getLabel().c_str());
    GLGuiButton::releasing(pos);
  }



  /**
   * @brief draws the GLGuiPushButton
   */
  void GLGuiPushButton::draw() const
  {
    this->beginDraw();
    GLGuiButton::draw();

    this->frontMaterial().select();
    this->drawRect(this->frontRect());
    this->endDraw();
    //   this->label->draw();
    //  printf("test");
  }

  /**
   * updates the GLGuiPushButton
   */
  void GLGuiPushButton::update()
  {

  }
}
