/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_button.h"

#include "text.h"


namespace OrxGui
{
  /**
   * standard constructor
  */
  GLGuiButton::GLGuiButton (const std::string& label)
  {
    this->init();

    this->label.setText( label );
  }


  /**
   * standard deconstructor
  */
  GLGuiButton::~GLGuiButton()
  {
    /* this does not have to be done, since the Label is a child,
     * and will be deleted by Element2D's deletion Process
     * delete this->label;
    */
  }

  /**
   * @brief initializes the GUI-element
   */
  void GLGuiButton::init()
  {
    this->setClassID(CL_GLGUI_BUTTON, "GLGuiButton");
    this->setFocusable(true);
    this->setClickable(true);

    this->label.setFont("fonts/final_frontier.ttf", 20);
    this->frontMaterial().setDiffuse(1, 0, 0);

    this->label.setParent2D(this);
  }


  void GLGuiButton::setLabel(const std::string& label)
  {
    this->label.setText(label);
    this->resize();
  }



  void GLGuiButton::clicking(const Vector2D& pos)
  {
    emit(clicked());
  }
  void GLGuiButton::releasing(const Vector2D& pos)
  {
    emit(released());
  }

  /**
   * @brief draws the GLGuiButton
   */
  void GLGuiButton::draw() const
  {
    GLGuiWidget::draw();
  }
}
