#include "Script.h"


Script::Script()
{

  luaState = lua_open();

  luaopen_base(luaState);
  luaopen_table(luaState);
  luaopen_io(luaState);
  luaopen_string(luaState);
  luaopen_math(luaState);
  luaopen_debug(luaState);

}


Script::~Script()
{
  lua_setgcthreshold(luaState, 0);  // collected garbage
  lua_close(luaState);
}


bool Script::loadFile(std::string& filename)
 {
   int error = luaL_loadfile (luaState, filename.c_str());

   if(error == 0)
   {
     return true;
   }
   else
   {
     switch(error)
     {
     case LUA_ERRSYNTAX :
       printf("Syntax error in file %s \n",filename.c_str() );

     case LUA_ERRMEM :
       printf("Memory allocation error in file %s", filename.c_str() );
     }
   }

 }



 void Script::selectFunction(std::string& functionName, int retCount)
 {
   returnCount = retCount;
   currentFunction = functionName;
   lua_pushlstring(luaState, currentFunction.c_str(), currentFunction.size() );
   lua_gettable(luaState, LUA_GLOBALSINDEX);
 }

 //return number of returned values
 int  Script::executeFunction()
 {
    lua_call(luaState, argumentCount, returnCount);
 }


 //overload this function to add different types
 bool Script::pushParam(int param, std::string& toFunction)
 {
   if(currentFunction.compare(toFunction) != 0)
   {
    lua_pushnumber(luaState,  param);
    return true;
   }
   else
   {
     printf("Couldn't add parameter because the wrong function is selected: %s instead of %s", currentFunction.c_str(), toFunction.c_str());
     return false;
   }

 }


 bool Script::pushParam(float param, std::string& toFunction)
 {
   if(currentFunction.compare(toFunction) != 0)
   {
     lua_pushnumber(luaState, param);
     return true;
   }
   else
   {
     printf("Couldn't add parameter because the wrong function is selected: %s instead of %s", currentFunction.c_str(), toFunction.c_str());
     return false;
   }

 }
