/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: hdavid, amaechler
*/

#include "lightening_effect.h"

#include "state.h"
#include "util/loading/load_param.h"
#include "util/loading/factory.h"
#include "effects/billboard.h"

#include "glincl.h"
#include "parser/tinyxml/tinyxml.h"

using namespace std;

CREATE_FACTORY(LighteningEffect, CL_LIGHTENING_EFFECT);

LighteningEffect::LighteningEffect(const TiXmlElement* root)
{
	this->setClassID(CL_LIGHTENING_EFFECT, "LighteningEffect");
  
  
  billboard = new Billboard(NULL);
  billboard->setTexture("maps/lightning_bolt.png");
  billboard->setSize(10, 20);
  //billboard->setAbsCoor2D(10,10);
  //billboard->setVisibility(true);
  
  
	this->init();

	if (root != NULL)
		this->loadParams(root);

	this->activate();
}

LighteningEffect::~LighteningEffect()
{
	this->deactivate();
}

void LighteningEffect::loadParams(const TiXmlElement* root)
{
	WeatherEffect::loadParams(root);
}


bool LighteningEffect::init()
{
	//Default values
}


bool LighteningEffect::activate()
{
	PRINTF(0)( "Activating LighteningEffect\n" );

}


bool LighteningEffect::deactivate()
{
	PRINTF(0)("Deactivating LighteningEffect\n");
}

void LighteningEffect::tick (float dt)
{

}
