/*!
 * @file player_stats.h
 * @brief Definition of PlayerStats
 */

#ifndef _PLAYER_STATS_H
#define _PLAYER_STATS_H

#include "synchronizeable.h"
#include "playable.h"

#include <string>
#include <list>

//! A class for storing player information
class PlayerStats : public Synchronizeable 
{

  public:
    PlayerStats( const TiXmlElement* root = NULL );
    PlayerStats( int userId );
    virtual ~PlayerStats();
    
    virtual void varChangeHandler( std::list<int> & id );
    
    static PlayerStats * getStats( int userId );
    
    inline int getUserId(){ return userId; }
    
    inline int getTeamId(){ return teamId; }
    inline void setTeamId( int teamId ){ this->teamId = teamId; }
    
    inline int getScore(){ return score; }
    inline void setScore( int score ){ this->score = score; }
    
    inline int getPlayableClassId(){ return playableClassId; }
    void setPlayableClassId( int classId ){ this->playableClassId = classId; };
    
    inline int getPlayableUniqueId(){ return playableUniqueId; }
    void setPlayableUniqueId( int uniqueId );
    
    inline std::string getModelFileName(){ return modelFileName; }
    inline void setModelFileName( std::string filename ){ modelFileName = filename; }
    
    Playable * getPlayable();

  private:
    int userId;                //!< userId
    int teamId;                //!< teamId

    int score;                 //!< users score points
    int playableClassId;       //!< players playable class id
    int playableUniqueId;      //!< playable's uniqueId
    std::string modelFileName; //!< model filename

    Playable * playable;       //!< pointer to players playable

    // handles for SynchronizeableVars
    int userId_handle;
    int groupId_handle;
    int score_handle;
    int playableClassId_handle;
    int playableUniqueId_handle;
    int modelFileName_handle;
    
    void init();
};

#endif /* _PLAYER_STATS_H */
