/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Wuest
   co-programmer: ...
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK

#include "util/loading/factory.h"
#include "state.h"
#include "class_list.h"

#include "network_stream.h"
#include "shared_network_data.h"
#include "converter.h"
#include "message_manager.h"

#include "playable.h"
#include "player.h"

#include "game_world.h"

#include "game_rules.h"
#include "network_game_rules.h"

#include "network_game_manager.h"


/* using namespace std is default, this needs to be here */
using namespace std;

NetworkGameManager* NetworkGameManager::singletonRef = NULL;

/*!
 * Standard constructor
 */
NetworkGameManager::NetworkGameManager()
  : Synchronizeable()
{
  PRINTF(0)("START\n");

  /* set the class id for the base object */
  this->setClassID(CL_NETWORK_GAME_MANAGER, "NetworkGameManager");

  this->setSynchronized(true);

}

/*!
 * Standard destructor
 */
NetworkGameManager::~NetworkGameManager()
{
}


/**
 * insert new player into game
 * @param userId 
 * @return 
 */
bool NetworkGameManager::signalNewPlayer( int userId )
{
  assert( SharedNetworkData::getInstance()->isGameServer() );
  assert( State::getGameRules() );
  assert( State::getGameRules()->isA( CL_NETWORK_GAME_RULES ) );
  
  NetworkGameRules & rules = *(dynamic_cast<NetworkGameRules*>(State::getGameRules()));
  
  int team = rules.getTeamForNewUser();
  ClassID playableClassId = rules.getPlayableClassId( team );
  std::string playableModel = rules.getPlayableModelFileName( team, playableClassId );
  
  BaseObject * bo = Factory::fabricate( playableClassId );
  
  assert( bo != NULL );
  assert( bo->isA( CL_PLAYABLE ) );
  
  Playable & playable = *(dynamic_cast<Playable*>(bo));
  
  playable.loadModel( playableModel );
  playable.setOwner( userId );
  playable.setUniqueID( SharedNetworkData::getInstance()->getNewUniqueID() );
  playable.setSynchronized( true );
  
  PlayerStats * stats = rules.getNewPlayerStats( userId );
  
  stats->setUniqueID( SharedNetworkData::getInstance()->getNewUniqueID() );
  stats->setSynchronized( true );
  stats->setOwner( getHostID() );
  
  stats->setTeamId( team );
  stats->setPlayableClassId( playableClassId );
  stats->setPlayableUniqueId( playable.getUniqueID() );
  stats->setModelFileName( playableModel );
}


/**
 * remove player from game
 * @param userID 
 * @return 
 */
bool NetworkGameManager::signalLeftPlayer(int userID)
{
}







