/*!
 * @file glgui_checkbutton.h
 * The gl_ widget of th openglGUI
 *
 */

#ifndef _GLGUI_CHECKBUTTON_H
#define _GLGUI_CHECKBUTTON_H

#include "glgui_button.h"

namespace OrxGui
{

  // FORWARD DECLARATION

  //! This is part of the openglGUI class
  /**
   *
   */
  class GLGuiCheckButton : public GLGuiButton
  {

  public:
    GLGuiCheckButton(const std::string& label = "", bool active = false);
    virtual ~GLGuiCheckButton();


    bool    isActive() { return this->bActive; };
    void    setActivity(bool bActive);
    void    toggleActiveState();

    virtual void draw() const;
    virtual void update() {};

    DeclareSignal1(toggled, bool);

  protected:
    virtual void resize();
    virtual void releasing(const Vector2D& pos);

  private:
    void init();


  private:
    bool             bActive;

  };
}

#endif /* _GLGUI_CHECKBUTTON_H */
