/*!
 * @file glgui_.h
 * The gl_box widget of th openglGUI
 *
 */

#ifndef _GLGUI_BOX_H
#define _GLGUI_BOX_H

#include "glgui_container.h"
#include "glgui_defs.h"

namespace OrxGui
{
  //! This is BOX part of the openglGUI class
  /**
   *
   */
  class GLGuiBox : public GLGuiContainer
  {

  public:
    GLGuiBox(OrxGui::Orientation orientation = OrxGui::Horizontal);
    virtual ~GLGuiBox();

    void init();
    /** @returns the Orientation of the Box */
    OrxGui::Orientation orientation() const { return this->_orientation; };
    void setOrientation(OrxGui::Orientation orientation) { this->_orientation = orientation; };

    virtual void pack(GLGuiWidget* widget);
    virtual void unpack(GLGuiWidget* widget);
    virtual void showAll();
    virtual void hideAll();

    virtual void draw() const;

  private:
    virtual void resize();

    Orientation              _orientation;
    std::list<GLGuiWidget*>  children;
  };
}
#endif /* _GLGUI__H */
