/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_box.h"

namespace OrxGui
{
  /**
   * standard constructor
  */
  GLGuiBox::GLGuiBox (OrxGui::Orientation orientation)
  {
    this->init();

    this->setOrientation(orientation);
  }


  /**
   * standard deconstructor
  */
  GLGuiBox::~GLGuiBox()
  {}

  /**
   * initializes the GUI-element
   */
  void GLGuiBox::init()
  {
    this->setClassID(CL_GLGUI_BOX, "GLGuiBox");
  }

  void GLGuiBox::pack(GLGuiWidget* widget)
  {
    assert (widget != NULL);

    this->children.push_back(widget);
  }


  void GLGuiBox::unpack(GLGuiWidget* widget)
  {
    assert(widget == NULL);

    this->children.remove(widget);
  }

  void GLGuiBox::showAll()
  {
    std::list<GLGuiWidget*>::iterator itC = this->children.begin();
    while (itC != this->children.end())
    {
      if ((*itC)->isA(CL_GLGUI_CONTAINER))
        static_cast<GLGuiContainer*>(*itC)->showAll();
      else
        (*itC)->show();
      itC++;
    }

    this->show();

  }

  void GLGuiBox::hideAll()
  {
    std::list<GLGuiWidget*>::iterator itC = this->children.begin();
    while (itC != this->children.end())
    {
      if ((*itC)->isA(CL_GLGUI_CONTAINER))
        static_cast<GLGuiContainer*>(*itC)->hideAll();
      else
        (*itC)->hide();
      itC++;
    }

    this->hide();
  }


  /**
   * draws the GLGuiBox
   */
  void GLGuiBox::draw() const
  {
  }
}
