/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#include "executor.h"

std::string ExecutorFunctional_returningString_from;
std::string ExecutorFunctional_returningString_default;


template<> MT_Type ExecutorParamType<bool>() { return MT_BOOL; };
template<> MT_Type ExecutorParamType<int>() { return MT_INT; };
template<> MT_Type ExecutorParamType<unsigned int>() { return MT_UINT; };
template<> MT_Type ExecutorParamType<float>() { return MT_FLOAT; };
template<> MT_Type ExecutorParamType<char>() { return MT_CHAR; };
template<> MT_Type ExecutorParamType<const std::string&>() { return MT_STRING; };

template<> bool fromString<bool>(const std::string& input, bool defaultValue) { return isBool(input, defaultValue); };
template<> int fromString<int>(const std::string& input, int defaultValue) { return isInt(input, defaultValue); };
template<> unsigned int fromString<unsigned int>(const std::string& input, unsigned int defaultValue) { return isInt(input, defaultValue); };
template<> float fromString<float>(const std::string& input, float defaultValue) { return isFloat(input, defaultValue); };
template<> char fromString<char>(const std::string& input, char defaultValue) { return isInt(input, defaultValue); };
template<> const std::string& fromString<const std::string&>(const std::string& input, const std::string& defaultValue) { return ExecutorFunctional_returningString_from = isString(input, defaultValue); };


template<> bool fromMulti<bool>(const MultiType& multi) { return multi.getBool(); };
template<> int fromMulti<int>(const MultiType& multi) { return multi.getInt(); }
template<> unsigned int fromMulti<unsigned int>(const MultiType& multi) { return multi.getInt(); };
template<> float fromMulti<float>(const MultiType& multi) { return multi.getFloat(); };
template<> char fromMulti<char>(const MultiType& multi) { return multi.getChar(); };
template<> const std::string& fromMulti<const std::string&>(const MultiType& multi) { return multi.getConstString(); };


template<> bool getDefault<bool>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getBool(); };
template<> int getDefault<int>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getInt(); };
template<> unsigned int getDefault<unsigned int>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getInt(); };
template<> float getDefault<float>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getFloat(); };
template<> char getDefault<char>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getChar(); };
template<> const std::string& getDefault<const std::string&>(const MultiType* const defaultValues, unsigned int i) { return ExecutorFunctional_returningString_default = defaultValues[i].getString(); };







/**
 * A LITTLE TESTING SUITE FOR THE EXECUTOR.
 *
#include "executor/executor_functional.h"

#define EXECUTOR_FUNCTIONAL_USE_STATIC
#include "executor/executor_functional.h"

class TestClass : public BaseObject
{
  public:
    TestClass() {};

    void printTest() { printf ("TEST\n"); };
    void printTestInt(int i) { printf ("%d\n", i); };
    void printTestBool(bool b) { printf("%d\n", (int)b); };
    void printTwoVals(int b, int i) { printf ("%d %d\n", b, i); };
    void printStrings(const std::string& name) { printf("String:: '%s'\n", name.c_str()); };
    static void printStatic() { printf("STATIC\n");};
};

void TEST()
{
  TestClass test;
  SubString testStrings("1 SCHEISSE, 2, 3", ",", SubString::WhiteSpaces, false);
  (*createExecutor<TestClass>(&TestClass::printTest))(&test, testStrings);
  (*createExecutor<TestClass>(&TestClass::printTestInt))(&test, testStrings);
  (*createExecutor<TestClass>(&TestClass::printTestBool))(&test, testStrings);
  (*createExecutor<TestClass>(&TestClass::printTwoVals))(&test, testStrings);
  (*createExecutor<TestClass>(&TestClass::printStatic))(&test, testStrings);
  (*createExecutor<TestClass>(&TestClass::printStrings))(&test, testStrings);

}
*/
