/*!
 * @file billboard.h
 */

#ifndef _BILLBOARD_H
#define _BILLBOARD_H

#include "world_entity.h"

class Material;
class TiXmlElement;

class Billboard : public WorldEntity
{
  public:
    Billboard(const TiXmlElement* root = NULL);
    virtual ~Billboard();

    void init();
    void loadParams(const TiXmlElement* root);

    void setSize(float sizeX, float sizeY);
    void setTexture(const std::string& textureFile);

    virtual void tick(float dt);
    virtual void draw() const;

  private:
    Material*        material;
    float sizeX;
    float sizeY;
};

#endif /* _BILLBOARD_H */
