/**
* @file lightening_effect.h
*/

#ifndef _LIGHTENING_EFFECT
#define _LIGHTENING_EFFECT

#include "vector.h"
#include "vector2D.h"

#include "weather_effect.h"

#include "sound_buffer.h"
#include "sound_source.h"


class Billboard;

class LighteningEffect : public WeatherEffect
{
	public:
		LighteningEffect(const TiXmlElement* root = NULL);
		virtual ~LighteningEffect();

		virtual void loadParams(const TiXmlElement* root);

		virtual bool init();

		virtual bool activate();
		virtual bool deactivate();

		virtual void tick(float dt);

	private:
    Billboard* billboard;

};

#endif  /* _LIGHTENING_EFFECT */
