/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION_REACTION



#include "collision.h"
#include "collision_handle.h"
#include "cr_defs.h"

#include "cr_engine.h"

using namespace std;


/**
 * standard constructor
 */
CREngine::CREngine ()
  : BaseObject()
{
   this->setClassID(CL_CR_ENGINE, "CREngine");
   this->setName("CREngine");

   this->init();
}

/**
 *  the singleton reference to this class
 */
CREngine* CREngine::singletonRef = NULL;

/**
   @brief standard deconstructor
 */
CREngine::~CREngine ()
{
  CREngine::singletonRef = NULL;
}

/**
 * inits the CREngine to a working state
 */
void CREngine::init()
{
  // create a list of Collision events (precaching)
  Collision* collisions = new Collision[CR_MAX_COLLISIONS];
  for( int i = 0; i < CR_MAX_COLLISIONS; i++)
    this->cachedCollisions.push_back(&collisions[i]);
}


void CREngine::reset()
{
  // first clear all CollisionHandles
  std::vector<CollisionHandle*>::iterator it;
  for( it = this->collisionHandles.begin(); it != this->collisionHandles.end(); it++)
    delete *it;
  this->collisionHandles.clear();
}


/**
 * subscribes a WorldEntity for a CollisionReaction
 *  @param owner: the WE to subscribe
 *  @param type: the type of collision reaction to perform
 */
CollisionHandle* CREngine::subscribeReaction(WorldEntity* owner, CRType type)
{
  CollisionHandle* ch = new CollisionHandle(owner, type);
  this->collisionHandles.push_back(ch);
}


bool CREngine::unsubscribeReaction(WorldEntity* worldEntity)
{}


bool CREngine::unsubscribeReaction(CollisionHandle* collisionHandle)
{}


void CREngine::handleCollisions()
{}



void CREngine::debug()
{

}

