/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION_REACTION

#include "collision_handle.h"




using namespace std;


/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
CollisionHandle::CollisionHandle (WorldEntity* owner, CREngine::CRType type)
{
  this->setClassID(CL_COLLISION_HANDLE, "CollisionHandle");

  this->owner = owner;
  this->type = type;

}


/**
 * standard deconstructor
*/
CollisionHandle::~CollisionHandle ()
{
  // delete what has to be deleted here
}


/**
 * add more filter targets to this collision handle
 *  @param classID the classid to look for
 */
void CollisionHandle::addTarget(long classID)
{
  // make sure there is no dublicate
  std::vector<long>::iterator it;
  for(  it = this->targetList.begin(); it != this->targetList.end(); it++)
    if(*it == classID)
      return;

  // add element
  this->targetList.push_back(classID);
}


/**
 * this is the function to be called on a collision event for this handle
 *  @param collision the collision objects containing all collision informations
 */
void CollisionHandle::registerCollision(Collision* collision)
{
  this->collisionList.push_back(collision);
}

/**
 * flushes the collision list
 */
void CollisionHandle::flushCollisions()
{
  std::vector<Collision*>::iterator it;
  for( it = this->collisionList.begin(); it != this->collisionList.end(); it++)
    CREngine::getInstance()->pushCollisionObject(*it);
  this->collisionList.clear();
}


/**
 * handles the collisions and react according to algorithm
 */
void CollisionHandle::handleCollisions()
{

  // collision reaction calculations

  // now set state to dispatched
  this->bDispatched = true;
  this->flushCollisions();
}
