/*!
 * @file proto_singleton.h
 * @brief Definition of the GLGuiHandler singleton Class
*/

#ifndef _GLGUI_HANDLER_H
#define _GLGUI_HANDLER_H

#include "event_listener.h"
#include "glgui_widget.h"

namespace OrxGui
{

  class GLGuiCursor;

  // FORWARD DECLARATION

  //! A singleton class for the GLGui-Handler
  class GLGuiHandler : public EventListener
  {

  public:
    virtual ~GLGuiHandler(void);
    /** @returns a Pointer to the only object of this Class */
    inline static GLGuiHandler* getInstance(void) { if (!GLGuiHandler::singletonRef) GLGuiHandler::singletonRef = new GLGuiHandler();  return GLGuiHandler::singletonRef; };

    void activateCursor();
    void deactivateCursor(/** ignore param */ bool deleteCursor = true);
    GLGuiCursor* getCursor() const { return this->cursor; }

    Vector2D cursorPositionOverFocusedWidget() const;
    const Vector2D& cursorPositionAbs() const;
    const Vector2D& cursorPositionRel(const GLGuiWidget* const widget) const;

    void activate();
    void deactivate();


    virtual void process(const Event &event);
    void draw();
    void tick(float dt);

  private:
    GLGuiHandler(void);
    static GLGuiHandler* singletonRef;


    bool                 isActive;
    GLGuiCursor*         cursor;

  };
}

#endif /* _GLGUI_HANDLER_H */
