/*!
 * @file glgui_slider.h
 * The gl_ widget of th openglGUI
 *
 */

#ifndef _GLGUI_SLIDER_H
#define _GLGUI_SLIDER_H

#include "glgui_widget.h"
#include "glgui_defs.h"

namespace OrxGui
{
  // FORWARD DECLARATION

  //! This is part of the openglGUI class
  /**
   * The Slider is a Widget, with a Range and a Value.
   */
  class GLGuiSlider : public GLGuiWidget
  {

  public:
    GLGuiSlider();
    virtual ~GLGuiSlider();

    /** @returns the Value of the Slider. */
    float value() const { return this->_value; }
    /** @returns the minimum of the sliders range */
    float min() const { return this->_minValue; };
    /** @returns the maximum of the sliders range */
    float max() const { return this->_maxValue; };
    /** @returns the step size */
    float step() const { return this->_step; };

    void setValue(float value);

    void setMin(float minimum);
    void setMax(float maximum);
    void setRange(float minimum, float maximum);

    void setStep(float step);


//    virtual void tick(float dt);
    virtual bool processEvent(const Event& event);
    virtual void draw() const;

  protected:
    virtual void resize();

    virtual void clicked(const Vector2D& pos);
    virtual void released(const Vector2D& pos);
    virtual void removedFocus();

  private:
    void init();
    float sliderPosition() const;
    float sliderValue(float position) const;
  private:

    Orientation      orientation;

    float            _maxValue;
    float            _minValue;
    float            _step;

    float            _value;

    float            _sliderWidth;

    bool             grabbed;

  };
}
#endif /* _GLGUI_SLIDER_H */
