/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_slider.h"
#include "event_def.h"

namespace OrxGui
{

  /**
   * standard constructor
  */
  GLGuiSlider::GLGuiSlider ()
  {
    this->init();

  }


  /**
   * standard deconstructor
  */
  GLGuiSlider::~GLGuiSlider()
  {}

  /**
   * initializes the GUI-element
   */
  void GLGuiSlider::init()
  {

    this->setClassID(CL_GLGUI_SLIDER, "GLGuiSlider");

    this->setClickable( );
    this->setFocusable( );

    this->_value = 0.0;
    this->_minValue = 0.0;
    this->_maxValue = 1.0;
    this->_step = 0.1;
    this->_sliderWidth = 5.0;
    this->grabbed = false;

    this->setSize2D(100, 30);
    this->resize();
  }


  void GLGuiSlider::setValue(float value)
  {
    if (value < this->min())
      this->_value = min();
    else if (value > max())
      this->_value = max();
    else
      this->_value = value;
    printf("VALUE %f\n", _value);
  }

  void GLGuiSlider::setMin(float minimum)
  {
    if (minimum <= max())
     this->_minValue = minimum;

    if (this->value() < minimum)
      this->_value = minimum;
  }

  void GLGuiSlider::setMax(float maximum)
  {
    if (maximum >= min())
      this->_maxValue = maximum;

    if (this->value() > maximum)
      this->_value = maximum;
  }

  void GLGuiSlider::setRange(float minimum, float maximum)
  {
    if (minimum < maximum)
    {
      this->_minValue = minimum;
      this->_maxValue = maximum;
    }
    if (this->value() < minimum)
      this->_value = minimum;
    else if (this->value() > maximum)
      this->_value = maximum;
  }

  void GLGuiSlider::setStep(float step)
  {
    this->_step = step;
  }


  void GLGuiSlider::resize()
  {
    GLGuiWidget::resize();
    this->frontRect().setTopLeft(5, this->getSizeY2D()/2.0 - 1.0);
    this->frontRect().setSize(this->getSizeX2D() - 10.0, 5);
  }


  void GLGuiSlider::clicked(const Vector2D& pos)
  {
    GLGuiWidget::clicked(pos);

    float sliderPosition = this->sliderPosition();
    if (sliderPosition > pos.x + this->_sliderWidth)
      this->setValue(this->value() - this->step());

    else if (sliderPosition < pos.x - this->_sliderWidth)
      this->setValue(this->value() + this->step());
    else
      this->grabbed = true;



    printf("clicked at position: "), pos.debug();
  }

  void GLGuiSlider::released(const Vector2D& pos)
  {
    GLGuiWidget::released(pos);
    this->grabbed = false;
  }

  void GLGuiSlider::removedFocus()
  {
    GLGuiWidget::removedFocus();
    this->grabbed = false;
  }

  float GLGuiSlider::sliderPosition() const
  {
    return (this->_value - this->_minValue)/( this->_maxValue - this->_minValue) * (this->getSizeX2D() - 4.0) + 2.0;
  }

  float GLGuiSlider::sliderValue(float position) const
  {
    return (position - 2.0) / (this->getSizeX2D() - 4.0)  *( this->_maxValue - this->_minValue) +this->_minValue ;
  }

  /*  virtual void GLGuiSlider::tick(float dt)
    {
      if (this->grabbed)
      {
        this->setValue( 1);
      }
    }*/

  /**
   * @brief draws the GLGuiSlider
   */
  void GLGuiSlider::draw() const
  {
    this->beginDraw();
    GLGuiWidget::draw();

    this->frontMaterial().select();
    this->drawRect(this->frontRect());

    this->drawRect(Rect2D(this->sliderPosition()-_sliderWidth/2.0, 2, _sliderWidth, this->getSizeY2D() - 4));

    this->endDraw();
  }

  bool GLGuiSlider::processEvent( const Event& event )
  {
    if (this->grabbed && event.type == EV_MOUSE_MOTION)
    {
      this->setValue(sliderValue(event.x - this->getAbsCoor2D().x));
      return true;
    }
    return false;
  }
}
