/*!
 * @file glgui_checkbutton.h
 * The gl_ widget of th openglGUI
 *
 */

#ifndef _GLGUI_CHECKBUTTON_H
#define _GLGUI_CHECKBUTTON_H

#include "glgui_button.h"

namespace OrxGui
{

  // FORWARD DECLARATION

  //! This is part of the openglGUI class
  /**
   *
   */
  class GLGuiCheckButton : public GLGuiButton
  {

  public:
    GLGuiCheckButton(const std::string& label = "", bool active = false);
    virtual ~GLGuiCheckButton();

    virtual void released();

    bool    isActive() { return this->bActive; };
    void    setActivity(bool bActive);
    void    toggleActiveState();

    virtual void draw() const;
    virtual void update() {};

  protected:
    virtual void resize();

  private:
    void init();


  private:
    bool             bActive;

  };
}

#endif /* _GLGUI_CHECKBUTTON_H */
