/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_checkbutton.h"

#include "text.h"

namespace OrxGui
{


  /**
   * standard constructor
  */
  GLGuiCheckButton::GLGuiCheckButton (const std::string& label, bool active)
  : GLGuiButton(label)
  {
    this->init();
    this->bActive = active;

    this->resize();
  }


  /**
   * standard deconstructor
  */
  GLGuiCheckButton::~GLGuiCheckButton()
  {
  }

  /**
   * initializes the GUI-element
   */
  void GLGuiCheckButton::init()
  {
    this->setClassID(CL_GLGUI_CHECKBUTTON, "GLGuiCheckButton");
  }


  void GLGuiCheckButton::toggleActiveState()
  {
    this->bActive = !this->bActive;
  }

  void GLGuiCheckButton::resize()
  {
    this->label.setRelCoor2D(25, 5);
    this->setSize2D(this->label.getSizeX2D() + 30, this->label.getSizeY2D() + 10);
    GLGuiWidget::resize();
    this->frontRect().setTopLeft(1, 1);
    this->frontRect().setSize(this->getSizeX2D() -2, this->getSizeY2D() -2);
  }


  void GLGuiCheckButton::released()
  {
    printf("%s released\n", this->getLabel().c_str());
    GLGuiWidget::released();
    this->toggleActiveState();
  }



  /**
   * @brief draws the GLGuiPushButton
   */
  void GLGuiCheckButton::draw() const
  {
    this->startDraw();
    GLGuiButton::draw();

    this->frontMaterial().select();
    this->drawRect(this->frontRect());

    if (this->bActive)
    {
      glBegin(GL_QUADS);
      glColor3f( 1, 1 ,1);
      glTexCoord2i(0,0); glVertex2d(8, 8);
      glTexCoord2i(0,1); glVertex2d(8, this->getSizeY2D()-8);
      glTexCoord2i(1,1); glVertex2d(this->getSizeY2D()-8, this->getSizeY2D()-8);
      glTexCoord2i(1,0); glVertex2d(this->getSizeY2D()-8, 8);
      glEnd();


      // DRAW a cross :)
      glColor3f(0,0,0);
      glLineWidth(3.0);
      glBegin(GL_LINE_LOOP);
      glVertex2d(8,8);
      glVertex2d(this->getSizeY2D()/2, this->getSizeY2D()/2 - 1);

      glVertex2d(this->getSizeY2D() -8, 8);
      glVertex2d(this->getSizeY2D()/2 +1, this->getSizeY2D()/2);

      glVertex2d(this->getSizeY2D() -8, this->getSizeY2D() - 8);
      glVertex2d(this->getSizeY2D()/2, this->getSizeY2D()/2+1);

      glVertex2d(8, this->getSizeY2D() - 8);
      glVertex2d(this->getSizeY2D()/2 -1, this->getSizeY2D()/2);
      glEnd();
    }
    else
    {
      glBegin(GL_QUADS);
      glColor3f(0, 0, 0);
      glTexCoord2i(0,0); glVertex2d(8, 8);
      glTexCoord2i(0,1); glVertex2d(8, this->getSizeY2D()-8);
      glTexCoord2i(1,1); glVertex2d(this->getSizeY2D()-8, this->getSizeY2D()-8);
      glTexCoord2i(1,0); glVertex2d(this->getSizeY2D()-8, 8);
      glEnd();
    }

    this->endDraw();
  }
}
