/*!
 * @file glgui_button.h
 * The gl_BUTTON widget of th openglGUI
 *
 */

#ifndef _GLGUI_BUTTON_H
#define _GLGUI_BUTTON_H

#include "glgui_widget.h"

#include "text.h"

namespace OrxGui
{
  typedef enum
  {
    Button_Active,
    Button_Inactive,
    Button_Pressed,
    Button_Released,
    Button_Activating,
    Button_Deactivating,

  } ButtonState;

  //! This is part of the openglGUI class
  /**
   * The Button is an Abstract class, that can be pushed to Toggle its state.
   */
  class GLGuiButton : public GLGuiWidget
  {

  public:
    GLGuiButton(const std::string& label);
    virtual ~GLGuiButton();

    const std::string& getLabel() const { return this->label.getText(); };
    void setLabel(const std::string& label);

    virtual void draw() const;

    private:
      void init();



  protected:

    Text                 label;

  private:
    ButtonState          state;
  };
}
#endif /* _GLGUI__H */
