/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_widget.h"

#include "glgui_cursor.h"

#include "material.h"

#include "debug.h"

namespace OrxGui
{

  /**
   * @brief standard constructor
  */
  GLGuiWidget::GLGuiWidget (GLGuiWidget* parent)
  {
    this->init();

    if (parent != NULL)
      parent->addChild2D(this);
  }


  /**
   * @brief standard deconstructor
   */
  GLGuiWidget::~GLGuiWidget()
  {
    if (this == GLGuiWidget::_focused)
      GLGuiWidget::_focused = NULL;
  }

  GLGuiWidget* GLGuiWidget::_focused = NULL;
  GLGuiWidget* GLGuiWidget::_inputGrabber = NULL;



  /**
   * initializes the GUI-element
   */
  void GLGuiWidget::init()
  {
    this->setClassID(CL_GLGUI_WIDGET, "GLGuiWidget");

    this->_focusable = false;
    this->_clickable = false;
    this->_pushed = false;

    this->setVisibility(GLGUI_WIDGET_DEFAULT_VISIBLE);

    this->_backMat.setDiffuse(1.0, 1.0, 1.0);
    this->_frontMat.setDiffuse(1.0, 0.0, 0.0);

    this->widgetSignals.resize(SignalCount, SignalConnector());
  }


  /** @brief gives focus to this widget */
  void GLGuiWidget::giveFocus()
  {
    if (GLGuiWidget::focused() != NULL)
      GLGuiWidget::focused()->breakFocus();
    GLGuiWidget::_focused = this;
    this->receivedFocus();
  };

  void GLGuiWidget::breakFocus()
  {
    if (GLGuiWidget::_focused == this)
    {
      GLGuiWidget::_focused = NULL;
      this->_pushed = false;
      this->removedFocus();
    }
  };


  bool GLGuiWidget::focusOverWidget(const Vector2D& position) const
  {
    return (this->getAbsCoor2D().x < position.x && this->getAbsCoor2D().x + this->getSizeX2D() > position.x &&
        this->getAbsCoor2D().y < position.y && this->getAbsCoor2D().y + this->getSizeY2D() > position.y);
  }

  bool GLGuiWidget::focusOverWidget(const GLGuiCursor* const cursor) const
  {
    return this->focusOverWidget(cursor->getAbsCoor2D());
  }

  void GLGuiWidget::click()
  {
    assert (!this->_pushed);
    this->widgetSignals[Signal_click]("none");
    this->_pushed = true;

    this->clicked();
  }

  void GLGuiWidget::release()
  {
    if (this->_pushed)
    {
      this->widgetSignals[Signal_release]("none");

      this->released();
      this->_pushed = false;
    }
  }


  void GLGuiWidget::clicked()
  {
    this->frontMaterial().setDiffuse(0, 0, 1);

  }

  void GLGuiWidget::released()
  {
    this->frontMaterial().setDiffuse(0,1,0);

  }

  void GLGuiWidget::receivedFocus()
  {
    this->frontMaterial().setDiffuse(0, 1, 0);
  }

  void GLGuiWidget::removedFocus()
  {
    this->frontMaterial().setDiffuse(1, 0, 0);

  }

  void GLGuiWidget::destroyed()
  {
  };




  /**
   * @brief connects a Signal to the Gui-Elements' Event.
   * @param sinalType the Type of Signal to set. @see GLGuiSignalType
   * @param signal the name of the Signal
   */
  void GLGuiWidget::connectSignal(SignalType signalType, BaseObject* object, const Executor* signal)
  {
    if (signalType >= this->widgetSignals.size())
      return;

//    if (this->widgetSignals[signalType] != NULL)
//      PRINTF(2)("Already connected a Signal to '%s::%s' type %s... overwriting\n", this->getClassName(), this->getName(), "TEST");

    this->widgetSignals[signalType] = SignalConnector(object, signal);
  }

  /**
   * @brief removes a Signal from a Gui-ELements' Event
   * @param signalType the type of Signal to remove.
   */
  void GLGuiWidget::disconnectSignal(SignalType signalType)
  {
    if (signalType >= this->widgetSignals.size())
      return;

    this->widgetSignals[signalType] = SignalConnector();
  }


  void GLGuiWidget::show()
  {
    this->setVisibility(true);
  }

  void GLGuiWidget::hide()
  {
    this->setVisibility(false);
  }


  void GLGuiWidget::draw() const
  {
    this->backMaterial().select();

    glBegin(GL_QUADS);
    glTexCoord2i(0,0); glVertex2d(0, 0);
    glTexCoord2i(0,1); glVertex2d(0, this->getSizeY2D());
    glTexCoord2i(1,1); glVertex2d(this->getSizeX2D(), this->getSizeY2D());
    glTexCoord2i(1,0); glVertex2d(this->getSizeX2D(), 0);
    glEnd();
  }

}
