/*!
 * @file glgui_slider.h
 * The gl_ widget of th openglGUI
 *
 */

#ifndef _GLGUI_SLIDER_H
#define _GLGUI_SLIDER_H

#include "glgui_widget.h"
#include "glgui_defs.h"

namespace OrxGui
{
  // FORWARD DECLARATION

  //! This is part of the openglGUI class
  /**
   *
   */
  class GLGuiSlider : public GLGuiWidget
  {

  public:
    GLGuiSlider();
    virtual ~GLGuiSlider();

    /** @returns the Value of the Slider. */
    float value() const { return this->_value; }
    /** @returns the minimum of the sliders range */
    float min() const { return this->_minValue; };
    /** @returns the maximum of the sliders range */
    float max() const { return this->_maxValue; };
    /** @returns the step size */
    float step() const { return this->_step; };

    void setValue(float value);

    void setMin(float minimum);
    void setMax(float maximum);
    void setRange(float minimum, float maximum);

    void setStep(float step);


    virtual void draw() const;

  private:
    void init();
    private:

    Orientation      orientation;

    float            _maxValue;
    float            _minValue;
    float            _step;

    float            _value;

  };
}
#endif /* _GLGUI_SLIDER_H */
