/*!
 * @file glgui_inputline.h
 * The gl_INPUTLINE widget of th openglGUI
 *
 */

#ifndef _GLGUI_INPUTLINE_H
#define _GLGUI_INPUTLINE_H

#include "glgui_widget.h"
#include "text.h"
#include "event.h"

// FORWARD DECLARATION
namespace OrxGui
{

  //! This is part of the openglGUI class
  /**
   *
   */
  class GLGuiInputLine : public OrxGui::GLGuiWidget
  {

  public:
    GLGuiInputLine();
    virtual ~GLGuiInputLine();

    void init();

    void setText(const std::string& text);
    void append(const std::string& appendText);
    void appendCharacter(char character);
    void removeCharacters(unsigned int chars);
    const std::string& getName() const { return this->text.getText(); };


    virtual void tick(float dt);
    virtual void draw() const;

    virtual bool processEvent(const Event& event);

    private:
      void resize();


  private:
    Text                    text;             //!< The Text to display inside of the InputLine.

    Uint16                  pressedKey;       //!< the pressed key that will be repeated.
    Uint16                  pressedKeyName;   //!< The Name of the Key, that was pressed.

    float                   delayNext;        //!< How much time must pass before next output.

    static float            repeatDelay;
    static float            repeatRate;


  };
}

#endif /* _GLGUI_INPUTLINE_H */
