/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_inputline.h"

namespace OrxGui
{
  /**
   * standard constructor
  */
  GLGuiInputLine::GLGuiInputLine ()
  {
    this->init();

  }


  /**
   * standard deconstructor
  */
  GLGuiInputLine::~GLGuiInputLine()
  {}

  float GLGuiInputLine::repeatDelay = 1.0;
  float GLGuiInputLine::repeatRate = .1;


  /**
   * initializes the GUI-element
   */
  void GLGuiInputLine::init()
  {
    this->setClassID(CL_GLGUI_INPUTLINE, "GLGuiInputLine");

    this->setFocusable(true);
    this->setClickable(true);

    this->text.setParent2D(this);
    this->text.setRelCoor2D(4,4);
    this->text.setFont("fonts/final_frontier.ttf", 20);

    this->setText("SUPERTEST");
  }

  void GLGuiInputLine::setText(const std::string& text)
  {
    this->text.setText(text);
    this->resize();
  }

  void GLGuiInputLine::append(const std::string& appendText)
  {
    this->text.append(appendText);
    this->resize();
  }

  void GLGuiInputLine::appendCharacter(char character)
  {
    this->text.appendCharacter(character);
    this->resize();
  }


  void GLGuiInputLine::removeCharacters(unsigned int chars)
  {
    this->text.removeCharacters(chars);
    this->resize();
  }

  bool GLGuiInputLine::processEvent(const Event& event)
  {
    if (event.bPressed)
    {
      if (event.type == SDLK_BACKSPACE)
      {
        this->delayNext = GLGuiInputLine::repeatDelay;
        this->pressedKey = SDLK_BACKSPACE;
        this->pressedKeyName = SDLK_BACKSPACE;
        this->removeCharacters(1);
        return true;
      }
      // any other keyboard key
      else if (likely(event.type < 127))
      {
        this->appendCharacter(event.x);
        this->pressedKey = event.type;
        this->pressedKeyName = event.x;
        return true;
      }
      this->delayNext = this->repeatDelay;
    }
    else // if(!event.bPressed)
    {
      if (this->pressedKey == event.type)
      {
        this->pressedKeyName = 0;
        this->pressedKey = 0;
        this->delayNext = 0.0;
        return true;
      }
    }

    if (likely(event.type < 127))
    {
      this->appendCharacter(event.type);
      return true;
    }

    return false;
  }


  void GLGuiInputLine::resize()
  {
    this->setSize2D( this->text.getSize2D() + Vector2D(8, 8));
  }


  void GLGuiInputLine::tick(float dt)
  {
    if (this->delayNext > 0.0)
      this->delayNext -= dt;
  }

  /**
   * draws the GLGuiInputLine
   */
  void GLGuiInputLine::draw() const
  {
    this->startDraw();
    GLGuiWidget::draw();

    this->frontMaterial().select();
    glBegin(GL_QUADS);

    glTexCoord2i(0,0); glVertex2d(3, 3);
    glTexCoord2i(0,1); glVertex2d(3, this->getSizeY2D() - 3);
    glTexCoord2i(1,1); glVertex2d(this->getSizeX2D() - 3, this->getSizeY2D() -3);
    glTexCoord2i(1,0); glVertex2d(this->getSizeX2D() - 3, 3);

    glEnd();
    this->endDraw();
  }
}
