/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_pushbutton.h"

#include "text.h"
#include "material.h"

namespace OrxGui
{

  /**
   * @brief standard constructor
   */
  GLGuiPushButton::GLGuiPushButton (const std::string& label)
  :GLGuiButton(label)
  {
    this->init();
  }


  /**
   * @brief standard deconstructor
  */
  GLGuiPushButton::~GLGuiPushButton()
  {
  }

  /**
   * initializes the GUI-element
   */
  void GLGuiPushButton::init()
  {
    this->setClassID(CL_GLGUI_PUSHBUTTON, "GLGuiPushButton");
    this->frontMat.setDiffuse(1,0,0);
  }

  void GLGuiPushButton::receivedFocus()
  {
    printf("%s received focus\n", this->getLabel().c_str());
    this->frontMaterial().setDiffuse(0, 1, 0);


    Vector test;
    this->frontMaterial().getDiffuseColor(test.x, test.y, test.z);
    test.debug();
  }
  void GLGuiPushButton::removedFocus()
  {
    printf("%s removed focus\n", this->getLabel().c_str());
    this->frontMaterial().setDiffuse(1, 0, 0);

  }

  void GLGuiPushButton::clicked()
  {
    printf("%s clicked\n", this->getLabel().c_str());
    this->frontMaterial().setDiffuse(0, 0, 1);
  }


  void GLGuiPushButton::released()
  {
    printf("%s released\n", this->getLabel().c_str());
    this->frontMat.setDiffuse(0,1,0);
  }



  /**
   * draws the GLGuiPushButton
   */
  void GLGuiPushButton::draw() const
  {
    this->startDraw();
    GLGuiButton::draw();

    this->frontMaterial().select();
    glBegin(GL_QUADS);

    glTexCoord2i(0,0); glVertex2d(1, 1);
    glTexCoord2i(0,1); glVertex2d(1, this->getSizeY2D() - 1);
    glTexCoord2i(1,1); glVertex2d(this->getSizeX2D() - 1, this->getSizeY2D() -1);
    glTexCoord2i(1,0); glVertex2d(this->getSizeX2D() - 1, 1);

    glEnd();
    this->endDraw();
    //   this->label->draw();
    //  printf("test");
  }

  /**
   * updates the GLGuiPushButton
   */
  void GLGuiPushButton::update()
  {

  }
}
