/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_button.h"

#include "text.h"


namespace OrxGui
{
  /**
   * standard constructor
  */
  GLGuiButton::GLGuiButton (const std::string& label)
  {
    this->init();
    this->setLabel(label);

    this->label.setFont("fonts/final_frontier.ttf", 100);
    this->label.setSize(10);
    this->label.setText("TEST");
  }


  /**
   * standard deconstructor
  */
  GLGuiButton::~GLGuiButton()
  {
    /* this does not have to be done, since the Label is a child,
     * and will be deleted by Element2D's deletion Process
     * delete this->label;
    */
  }

  /**
   * @brief initializes the GUI-element
   */
  void GLGuiButton::init()
  {
    this->setClassID(CL_GLGUI_BUTTON, "GLGuiButton");

    this->label.setParent2D(this);
  }

  void GLGuiButton::setLabel(const std::string& label)
  {
    this->label.setText(label);
    this->label.setRelCoor2D(5, 5);
    printf("SIZE OF TEXT %s %f\n", label.c_str(), this->label.getSizeX2D());
    this->setSize2D(this->label.getSizeX2D(), this->label.getSizeY2D()+10);
    printf("SIZE OF BUTTON %f\n", this->getSizeX2D());

  }


  /**
   * draws the GLGuiButton
   */
  void GLGuiButton::draw() const
  {
    GLGuiWidget::draw();
  }
}
