/*!
  \file gui_control.h
  \brief File that holds the class that creates the Control-Options.
*/
#ifndef _GUI_CONTROL_H
#define _GUI_CONTROL_H

#include "../gui_element.h"
#include <vector>
#include <string>
#include <QtGui/QGroupBox>
#include <QtGui/QPushButton>
#include "../gui_saveable.h"

namespace OrxGui
{
  //! Class that creates the Control-Options.
  class GuiControl : public OrxGui::Element, public QGroupBox
  {
  public:
    GuiControl(OrxGui::Gui* gui);
    virtual ~GuiControl();

  private:
  };

  class GuiControlInput : public QPushButton, public OrxGui::Saveable
  {
    Q_OBJECT
  public:
    GuiControlInput(const std::string& name, SaveableGroup* group, const std::string& defaultValue);

    virtual void load();
    virtual void save();


    virtual bool event(QEvent* e);
  public slots:
    void listen();
  signals:
    //    void optionChanged();

    private:
      bool bListening;
  };



}

#endif /* _GUI_CONTROL_H */
