/*!
 * @file signal_connector.h
 * @brief Definition of a SignalConnector class
*/

#ifndef _SIGNAL_CONNECTOR_H
#define _SIGNAL_CONNECTOR_H

#include "executor/executor.h"

namespace OrxGui
{
  //! A class for Conncting Signals to Objects, inside of the GUI
  class SignalConnector
  {
  public:
    SignalConnector();
    SignalConnector(BaseObject* object, const Executor* exec);
    SignalConnector(const SignalConnector& signalConnector);
    ~SignalConnector();

    SignalConnector& operator=(const SignalConnector& signalConnector);

    void operator()(const std::string& parameters) const;
    void execute(const std::string& parameters) const { (*this)(parameters); };

    bool isClean() const { return (this->object == NULL || this->exec == NULL); }


  private:
    BaseObject*          object;         //!< The object to call.
    const Executor*      exec;           //!< The Executor, that will be called, on object.
  };
}
#endif /* _SIGNAL_CONNECTOR_H */
