/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "signal_connector.h"

namespace OrxGui
{

  SignalConnector::SignalConnector( )
  {
    this->object = NULL;
    this->exec = NULL;
  }

  SignalConnector::SignalConnector(BaseObject* object, const Executor* executor)
  {
    this->object = object;
    this->exec = executor;
  };

  SignalConnector::SignalConnector(const SignalConnector& signalConnector)
  {
    this->object = signalConnector.object;
    this->exec = (signalConnector.exec == NULL) ? NULL : signalConnector.exec->clone();
  }

  SignalConnector::~SignalConnector()
  {
    delete exec;
  }

  SignalConnector& SignalConnector::operator=(const SignalConnector& signalConnector)
  {
    delete this->exec;
    this->object = signalConnector.object;
    this->exec = (signalConnector.exec == NULL) ? NULL : signalConnector.exec->clone();
  }

  void SignalConnector::operator()(const std::string& parameters) const
  {
    if (exec != NULL && object != NULL)
      (*this->exec)(this->object, parameters);
  }

}
