/*!
 * @file glgui_widget.h
 * The gl_widget of the openglGUI
 */

#ifndef _GLGUI_WIDGET_H
#define _GLGUI_WIDGET_H

#include "element_2d.h"
#include "event.h"
#include "material.h"

#include "glincl.h"
#include "signal_connector.h"

// FORWARD DECLARATION
class Material;

namespace OrxGui
{

  typedef enum
  {
    Signal_click     = 0,
    Signal_release,
    Signal_rollOn,
    Signal_rollOff,
    Signal_open,
    Signal_close,
    Signal_destroy,

    SignalCount,
  } SignalType;


  //! if the Element should be visible by default.
#define GLGUI_WIDGET_DEFAULT_VISIBLE       false

  //! This is widget part of the openglGUI class
  /**
   * A widget is the main class of all the elements of th GUI.
   */
  class GLGuiWidget : public Element2D
  {
  private:

  public:
    GLGuiWidget();
    virtual ~GLGuiWidget();

    void show();
    void hide();

    void connectSignal(SignalType signalType, BaseObject* obj, const Executor* signal);
    void disconnectSignal(SignalType signalType);
    bool focusOverWidget(float x, float y);

    // if something was clickt on the GUI-widget.
    virtual void clicked(const Event& event) {};
    virtual void released(const Event& event) {};

    virtual void receivedFocus() {};
    virtual void removedFocus() {};

    virtual void destroyed() {};

    virtual void update() {};
    virtual void draw() const;

    Material& backMaterial() { return this->backMat; };
    Material& frontMaterial() { return this->frontMat; };

  protected:
    inline void startDraw() const { glPushMatrix(); glTranslatef(this->getAbsCoor2D().x, this->getAbsCoor2D().y, 0); };
    inline void endDraw() const { glPopMatrix(); };

  private:
    void init();




  protected:
    Material               backMat;
    GLuint                 backModel;

    Material               frontMat;
    GLuint                 frontModel;

  private:
    std::vector<SignalConnector> widgetSignals;

    bool                   focusable;        //!< If this widget can receive focus.
    bool                   clickable;        //!< if this widget can be clicked upon.
  };
}
#endif /* _GLGUI_WIDGET_H */
