/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_widget.h"

#include "material.h"

#include "debug.h"

namespace OrxGui
{

  /**
   * standard constructor
  */
  GLGuiWidget::GLGuiWidget ( )
  {
    this->init();
  }


  /**
   * standard deconstructor
   */
  GLGuiWidget::~GLGuiWidget()
  {
  }


  /**
   * initializes the GUI-element
   */
  void GLGuiWidget::init()
  {
    this->setClassID(CL_GLGUI_WIDGET, "GLGuiWidget");

    this->focusable = true;
    this->clickable = true;
    this->setVisibility(GLGUI_WIDGET_DEFAULT_VISIBLE);
    //  this->setParent2D((Element2D*)NULL);

    this->backMat.setDiffuse(1.0, 1.0, 1.0);

    this->frontModel = 0;

    this->widgetSignals.resize(SignalCount, SignalConnector());
  }


  bool GLGuiWidget::focusOverWidget(float x, float y)
  {
    if (this->getAbsCoor2D().x < x && this->getAbsCoor2D().x + this->getSizeX2D() > x &&
        this->getAbsCoor2D().y < y && this->getAbsCoor2D().y + this->getSizeY2D() > y)
      return true;
    else
      return false;
  }

  /**
   * @brief connects a Signal to the Gui-Elements' Event.
   * @param sinalType the Type of Signal to set. @see GLGuiSignalType
   * @param signal the name of the Signal
   */
  void GLGuiWidget::connectSignal(SignalType signalType, BaseObject* object, const Executor* signal)
  {
    if (signalType >= this->widgetSignals.size())
      return;

//    if (this->widgetSignals[signalType] != NULL)
//      PRINTF(2)("Already connected a Signal to '%s::%s' type %s... overwriting\n", this->getClassName(), this->getName(), "TEST");

    this->widgetSignals[signalType] = SignalConnector(object, signal);
  }

  /**
   * @brief removes a Signal from a Gui-ELements' Event
   * @param signalType the type of Signal to remove.
   */
  void GLGuiWidget::disconnectSignal(SignalType signalType)
  {
    if (signalType >= this->widgetSignals.size())
      return;

    this->widgetSignals[signalType] = SignalConnector();
  }


  void GLGuiWidget::show()
  {
    this->setVisibility(true);
  }

  void GLGuiWidget::hide()
  {
    this->setVisibility(false);
  }


  void GLGuiWidget::draw() const
  {
    this->backMat.select();

    glBegin(GL_QUADS);
    glTexCoord2i(0,1); glVertex2d(0, 0);
    glTexCoord2i(0,0); glVertex2d(0, this->getSizeY2D());
    glTexCoord2i(1,0); glVertex2d(this->getSizeX2D(), this->getSizeY2D());
    glTexCoord2i(1,1); glVertex2d(this->getSizeX2D(), 0);
    glEnd();
  }

}
