/*!
 * @file cr_engine.h
 * @brief The collision reaction engine, defining generic collision reactions to collision events
*/

#ifndef _CR_ENGINE_
#define _CR_ENGINE_

#include "base_object.h"

// FORWARD DECLARATION
class CollisionHandle;
class Collision;

//! A default singleton class.
class CREngine : public BaseObject
{

  typedef enum CRType {
    CR_CONSERVATION_OF_MOMENTUM   = 0,

    CR_OBJECT_DAMAGE,
    CR_OBJECT_PICKUP,

    CR_VERTEX_TRAFO,

    CR_CALLBACK,

    CR_NUMBER
  };


public:
  virtual ~CREngine(void);
  /** @returns a Pointer to the only object of this Class */
  inline static CREngine* getInstance(void) { if (!singletonRef) singletonRef = new CREngine();  return singletonRef; };


  CollisionHandle* subscribeReaction(WorldEntity* worldEntity, ClassId targets, CRType type);

  bool unsubscribeReaction(WorldEntity* worldEntity);
  bool unsubscribeReaction(CollisionHandle* collisionHandle);


  /** @returns an instance to a collision object. instead of creating new object this ones can be resycled */
  inline Collision* getCollisionObject() { /* return the first element of the cache list*/ }
  /** @param collision: returns the Collision object back to the cache list */
  inline void putCollisionObject(Collision* collision) { this->cachedCollisions.push_back(collision); }


private:
  CREngine(void);
  static CREngine*                    singletonRef;             //!< the reference to the CREngine object (singleton)

  std::vector<CollisionHandle*>       collisionHandles;         //!< list with the collision handles
  std::vector<Collision*>             cachedCollisions;         //!< a list of unused, cached collision events
};

#endif /* _CR_ENGINE_ */
