/*!
 * @file mapped_water.h
 *
*/

#ifndef _MAPPED_WATER_H
#define _MAPPED_WATER_H

/* INCLUDES */
#include "world_entity.h"
#include "material.h"
#include "texture.h"
#include "shader.h"

class MappedWater : public WorldEntity
{
  public:
    MappedWater(const TiXmlElement* root = NULL);
    virtual ~MappedWater();

    void loadParams(const TiXmlElement* root);

    void activateReflection();
    void deactivateReflection();

    void activateRefraction();
    void deactivateRefraction();

    void draw() const;
    void tick(float dt);

  private:
    void setHeight(float height);

  private:
    float           waterHeight;       //!< y-coord of the Water
    Material        mat;

    int             textureSize;       //!< size of the texture
    Shader*         shader;

};

#endif  /* _MAPPED_WATER_H */
