/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Stefan Lienard
   co-programmer: ...
*/

#include "mapped_water.h"
#include "util/loading/load_param.h"
#include "util/loading/factory.h"
#include "util/loading/resource_manager.h"




CREATE_FACTORY(MappedWater, CL_MAPPED_WATER);


MappedWater::MappedWater(const TiXmlElement* root)
{
  this->setClassID(CL_MAPPED_WATER, "MappedWater");
  this->toList(OM_ENVIRON);

  if (root != NULL)
    this->loadParams(root);

  //! todo: rename texture to reflection texture
  // set up refleciton texture
  // FIXME mat.setDiffuseMap(this->texture, 0); doesnt work,
  mat.setDiffuseMap("pictures/dudvmap.bmp", GL_TEXTURE_2D, 0);
  // load refraction texture
  //mat.setDiffuseMap(&this->refractionTexture, 1);
  // load normal map
  //mat.setDiffuseMap("pictures/normalmap.bmp", GL_TEXTURE_2D, 2);
  // load dudv map
  //mat.setDiffuseMap("pictures/dudvmap.bmp", GL_TEXTURE_2D, 3);
  // set up depth texture
  //mat.setDiffuseMap(&this->depthTexture, 4);

  // set the size of the refraction and reflection textures



  /// MAKE THE MAPPING TEXTURE.
  // THIS IS A HACK AND SHOULD BE IN TEXTURE SOMEWHERE.
  this->textureSize = 512;
  unsigned int channels = 32;
  GLenum type = GL_RGBA;
  unsigned int* pTexture = new unsigned int [this->textureSize * this->textureSize * channels];
  memset(pTexture, 0, this->textureSize * this->textureSize * channels * sizeof(unsigned int));
  // Register the texture with OpenGL and bind it to the texture ID
  mat.select();
  glBindTexture(GL_TEXTURE_2D, this->mat.getDiffuseTexture(0));

  // Create the texture and store it on the video card
  glTexImage2D(GL_TEXTURE_2D, 0, channels, this->textureSize, this->textureSize, 0, type, GL_UNSIGNED_INT, pTexture);

  //gluBuild2DMipmaps(GL_TEXTURE_2D, channels, this->textureSize, this->textureSize, type,  GL_UNSIGNED_INT, pTexture);

  // Set the texture quality
  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
  glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
  glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);

  // Since we stored the texture space with OpenGL, we can delete the image data
  delete [] pTexture;


  //shader = new Shader( "/home/stefalie/svn/orxonox/data/trunk/shaders/water.vert", "/home/stefalie/svn/orxonox/data/trunk/shaders/mapped_water.frag");
  shader = new Shader( ResourceManager::getInstance()->getDataDir() + "/shaders/mapped_water.vert", ResourceManager::getInstance()->getDataDir() +"/shaders/mapped_water.frag");
}

MappedWater::~MappedWater()
{
  //delete shader;
}

void MappedWater::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);

  LoadParam(root, "waterHeight", this, MappedWater, setHeight);
}


void MappedWater::draw() const
{
  glPushMatrix();
  glTranslatef(0,this->waterHeight,0);

  //HACK
  glTranslatef(550,0,100);
  //glEnable(GL_LIGHTING);


  //mat.setDiffuseMap("pictures/sky-replace.jpg", GL_TEXTURE_2D, 1);
  //mat.setTransparency(1.0);
  //mat.setDiffuse(1.0, 0, .1);


  // HACK

  glDisable(GL_BLEND);
  //glActiveTexture(GL_TEXTURE0);
  //glBindTexture(GL_TEXTURE_2D, this->texture);

  mat.select();
  glBindTexture(GL_TEXTURE_2D, this->mat.getDiffuseTexture(0));


  // Shader init
  //this->shader->activateShader();
  //GLint uniform;

  // Set the variable "reflection" to correspond to the first texture unit
  //uniform = glGetUniformLocationARB(shader->getProgram(), "reflection");
  //glUniform1iARB(uniform, 0); //second paramter is the texture unit

  // Set the variable "refraction" to correspond to the second texture unit
  //uniform = glGetUniformLocationARB(shader->getProgram(), "refraction");
  //glUniform1iARB(uniform, 0);
  // FIXME glUniform1iARB(uniform, 1);

  // Set the variable "normalMap" to correspond to the third texture unit
  //uniform = glGetUniformLocationARB(shader->getProgram(), "normalMap");
  //glUniform1iARB(uniform, 2);

  // Set the variable "dudvMap" to correspond to the fourth texture unit
  //uniform = glGetUniformLocationARB(shader->getProgram(), "dudvMap");
  //glUniform1iARB(uniform, 3);

  // Set the variable "depthMap" to correspond to the fifth texture unit
  //uniform = glGetUniformLocationARB(shader->getProgram(), "depthMap");
  //glUniform1iARB(uniform, 4);
  // FIXME we dont have a depthMap yet :-(

  // Give the variable "waterColor" a blue color
  //uniform = glGetUniformLocationARB(shader->getProgram(), "waterColor");
  //glUniform4fARB(uniform, 0.1f, 0.2f, 0.4f, 1.0f);

  // FIXME set camera and light information
  Vector lightPos(100.0f, 150.0f, 100.0f);

  // Store the camera position in a variable
  //CVector3 vPosition = g_Camera.Position();
  //Vector vPosition(50.0f, 50.0f, 50.0f);

  // Give the variable "lightPos" our hard coded light position
  //uniform = glGetUniformLocationARB(shader->getProgram(), "lightPos");
  //glUniform4fARB(uniform, lightPos.x, lightPos.y, lightPos.z, 1.0f);

  // Give the variable "cameraPos" our camera position
  //uniform = glGetUniformLocationARB(shader->getProgram(), "cameraPos");
  //glUniform4fARB(uniform, vPosition.x, vPosition.y, vPosition.z, 1.0f);

  glBegin(GL_QUADS);
  glNormal3f(0, 1, 0);
  glMultiTexCoord2f(GL_TEXTURE0, 0, 0);
  glMultiTexCoord2f(GL_TEXTURE1, 0, 0);
  glMultiTexCoord2f(GL_TEXTURE2, 0, 0);
  glMultiTexCoord2f(GL_TEXTURE3, 0, 0);
  glMultiTexCoord2f(GL_TEXTURE4, 0, 0);
  glVertex3f(0, 0, 0);

  glMultiTexCoord2f(GL_TEXTURE0, 1, 0);
  glMultiTexCoord2f(GL_TEXTURE1, 1, 0);
  glMultiTexCoord2f(GL_TEXTURE2, 1, 0);
  glMultiTexCoord2f(GL_TEXTURE3, 1, 0);
  glMultiTexCoord2f(GL_TEXTURE4, 1, 0);
  glVertex3f(0, 0, 1000);

  glMultiTexCoord2f(GL_TEXTURE0, 1, 1);
  glMultiTexCoord2f(GL_TEXTURE1, 1, 1);
  glMultiTexCoord2f(GL_TEXTURE2, 1, 1);
  glMultiTexCoord2f(GL_TEXTURE3, 1, 1);
  glMultiTexCoord2f(GL_TEXTURE4, 1, 1);
  glVertex3f(1000, 0, 1000);

  glMultiTexCoord2f(GL_TEXTURE0, 0, 1);
  glMultiTexCoord2f(GL_TEXTURE1, 0, 1);
  glMultiTexCoord2f(GL_TEXTURE2, 0, 1);
  glMultiTexCoord2f(GL_TEXTURE3, 0, 1);
  glMultiTexCoord2f(GL_TEXTURE4, 0, 1);
  glVertex3f(1000, 0, 0);
  glEnd();

  this->shader->deactivateShader();

  glPopMatrix();
}

void MappedWater::tick(float dt)
{
}

void MappedWater::setHeight(float height)
{
  this->waterHeight = height;
}

void MappedWater::activateReflection()
{
  glPushAttrib(GL_VIEWPORT_BIT);
  

  //glLoadIdentity();
  glViewport(0,0, textureSize, textureSize);

  glPushMatrix();
  // Clear the color and depth bits, reset the matrix and position our camera.

  //g_Camera.Look();


  // If our camera is above the water we will render the scene flipped upside down.
  // In order to line up the reflection nicely with the world we have to translate
  // the world to the position of our reflected surface, multiplied by two.
  //if(g_Camera.Position().y > waterHeight)
  //{
  // Translate the world, then flip it upside down
  glTranslatef(0.0f, this->waterHeight*2.0f, 0.0f);
  glScalef(1.0, -1.0, 1.0);

  // Since the world is updside down we need to change the culling to FRONT
  glCullFace(GL_FRONT);

  // Set our plane equation and turn clipping on
  double plane[4] = {0.0, 1.0, 0.0, -waterHeight};
  //glEnable(GL_CLIP_PLANE0);
  //glClipPlane(GL_CLIP_PLANE0, plane);

  // Render the world upside down and clipped (only render the top flipped).
  // If we don't turn OFF caustics for the reflection texture we get horrible
  // artifacts in the water.  That is why we set bRenderCaustics to FALSE.
  //RenderWorld(false);

  // Turn clipping off
  // glDisable(GL_CLIP_PLANE0);

  // Restore back-face culling
  //  glCullFace(GL_BACK);
  //}
  /*else
  {
      // If the camera is below the water we don't want to flip the world,
      // but just render it clipped so only the top is drawn.
      double plane[4] = {0.0, 1.0, 0.0, waterHeight};
      glEnable(GL_CLIP_PLANE0);
      glClipPlane(GL_CLIP_PLANE0, plane);
      RenderWorld(true);
      glDisable(GL_CLIP_PLANE0);
  }*/
}


void MappedWater::deactivateReflection()
{
//  glBindTexture(GL_TEXTURE_2D, texture.getTexture()); //is done by mat.select();
  //glBindTexture(GL_TEXTURE_2D, this->mat.getDiffuseTexture(0));

  //mat.setDiffuseMap(&texture, 0);
  mat.select();
  glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, textureSize, textureSize);
  //glDisable(GL_CLIP_PLANE0);

  glPopMatrix();

  glPopAttrib();
}

void MappedWater::activateRefraction()
{
}

void MappedWater::deactivateRefraction()
{
}
