/*!
 * @file image_plane.h
 *  Definition of a image_plane
 */

#ifndef _IMAGE_PLANE_H
#define _IMAGE_PLANE_H


#include "element_2d.h"

#include "vector.h"



class Material;
class TiXmlElement;

//! A class that enables the
class ImagePlane :  public Element2D
{

  public:
    ImagePlane(const TiXmlElement* root = NULL);
    virtual ~ImagePlane();

    void init();
    void loadParams(const TiXmlElement* root);

    void setSize(float sizeX, float sizeY);
    void setTexture(const std::string& textureFile);
    void attachTo(PNode* pnode);

    virtual void tick(float dt);
    virtual void draw() const;


  private:
    Material*        material;             //!< a material for the ImagePlane
    float            rotationSpeed;        //!< Speed of the Rotation.

    PNode*           source;               //!< the source attached to it

};

#endif /* _IMAGE_PLANE_H */
