/*!
 * @file weather_effect.h
 *  
 */

#ifndef _WEATHER_EFFECT_H
#define _WEATHER_EFFECT_H

#include "base_object.h"


class WeatherEffect : public BaseObject
{
  public:
    WeatherEffect(const TiXmlElement* root = NULL);
    virtual ~WeatherEffect();

    virtual void loadParams(const TiXmlElement* root);

    virtual bool init();

    virtual bool activate() = 0;
    virtual bool deactivate() = 0;

    virtual void draw() const;
    virtual void tick(float dt);

    inline bool isActivated() const { return this->bActivated; }


  protected:
    bool              bActivated;
};


#endif /* _WEATHER_EFFECT */
