/**
* @file cloud_effect.h
*/

#ifndef _CLOUD_EFFECT
#define _CLOUD_EFFECT

#include "vector.h"
#include "vector2D.h"

#include "weather_effect.h"

#include "sound_buffer.h"
#include "sound_source.h"

class CloudEffect : public WeatherEffect
{
	public:
		CloudEffect(const TiXmlElement* root = NULL);
		virtual ~CloudEffect();

		virtual void loadParams(const TiXmlElement* root);

		virtual bool init();

		virtual bool activate();
		virtual bool deactivate();

		virtual void draw() const;
		virtual void tick(float dt);

		inline void setCloudAnimation(float timestep) { this->cloudAnimTimeStep = timestep; }

	private:
		// Basic noise maps 32x32
		float 														cloudMap32_a[32 * 32];
		float 														cloudMap32_b[32 * 32];
		float 														cloudMap32_c[32 * 32];

		// The cloud map 256x256
		float 														cloudMap256[256 * 256];

		// Temporary array to hold texture RGB values 
		char 															cloudTexture[256][256][3];

		GLuint 														texID[2];
		float 														timer;

		bool															cloudAnimTimeStep;

		float 														noise(int x, int y, int random);
		float 														interpolate(float x, float y, float  *map);
		void  														overlapOctaves();
		void  														expFilter();

		void  														genNoiseMap(float  *map);
		void  														genCloudTexture();
		void  														calcAnimMap(float timer);

};

#endif  /* _CLOUD_EFFECT */
