/*!
 * @file sun_effect.h
 *  
 */

#ifndef _SUN_EFFECT_H
#define _SUN_EFFECT_H

#include "base_object.h"


class TiXmlElement;

class SunEffect : public BaseObject
{
  public:
    SunEffect(const TiXmlElement* root = NULL);
    virtual ~SunEffect();

    virtual void loadParams(const TiXmlElement* root);

    virtual bool init();

    virtual bool activate() = 0;
    virtual bool deactivate() = 0;

    virtual void draw() const;
    virtual void tick(float dt);

    inline bool isActivated() const { return this->bActivated; }

  protected:
    bool              bActivated;
};


#endif /* _SUN_EFFECT */
