/**
* @file rain_effect.h
*/

#ifndef _RAIN_EFFECT
#define _RAIN_EFFECT

#include "vector.h"
#include "vector2D.h"
#include <string>

#include "particle_system.h"

class SparkParticles;
class PlainEmitter;

#include "weather_effect.h"

#include "sound_buffer.h"
#include "sound_source.h"


class RainEffect : public WeatherEffect
{
	public:
		RainEffect(const TiXmlElement* root = NULL);
		virtual ~RainEffect();

		virtual void loadParams(const TiXmlElement* root);

		virtual bool init();

		virtual bool activate();
		virtual bool deactivate();

		void activateRain();
		void deactivateRain();

		virtual void tick(float dt);

		inline void setRainCoord(float x, float y, float z) { this->rainCoord = Vector(x, y, z); }
		inline void setRainSize(float x, float y) { this->rainSize = Vector2D(x, y); }
		inline void setRainRate(float rate) { this->rainRate = rate;}
		inline void setRainVelocity(float velocity) { this->rainVelocity = -velocity; }
		inline void setRainLife(float life) { this->rainLife = life; }
		inline void setRainWind(int force) { this->rainWindForce = force; }
		inline void setRainOption(const std::string& option) { if (option == "moverain") this->rainMove = true; }


	private:
		static SparkParticles*						rainParticles;
		ParticleEmitter*									emitter;

		Vector														rainCoord;
		Vector2D													rainSize;
		GLfloat														rainRate;
		GLfloat														rainVelocity;
		GLfloat														rainLife;
		GLfloat														rainMaxParticles;
		int																rainWindForce;
		bool															rainMove;

		OrxSound::SoundSource			soundSource;
		OrxSound::SoundBuffer*			rainBuffer;
		OrxSound::SoundBuffer*			windBuffer;
};


#endif  /* _RAIN_EFFECT */
