/*!
 * @file atmospheric_engine.h
 *  
 */

#ifndef _ATMOSPHERIC_ENGINE_H
#define _ATMOSPHERIC_ENGINE_H

#include "base_object.h"


class TiXmlElement;

class AtmosphericEngine : public BaseObject
{
  public:
    ~AtmosphericEngine();

    /** @returns a Pointer to the only object of this Class */
    inline static AtmosphericEngine* getInstance() { if (!AtmosphericEngine::singletonRef) AtmosphericEngine::singletonRef = new AtmosphericEngine();  return AtmosphericEngine::singletonRef; };

    void loadParams(const TiXmlElement* root);

    void init();

    void draw() const;
    void tick(float dt);

    // inline bool isActivated() const { return this->bActivated; }

    void loadWeatherEffect(const TiXmlElement* root);
    void loadSunEffect(const TiXmlElement* root);

  private:

    AtmosphericEngine();

    static AtmosphericEngine*     singletonRef;       //!< Pointer to the only instance of this Class
};


#endif /* _ATMOSPHERIC_ENGINE */
