/*!
 * @file executor_functional.h
 * Definition of an Executor
 */

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/


#ifndef __EXECUTOR_FUNCTIONAL_H_
#define __EXECUTOR_FUNCTIONAL_H_



template<typename type> MT_Type ExecutorParamType() { return MT_EXT1; };
template<> MT_Type ExecutorParamType<bool>() { return MT_EXT1; };
template<> MT_Type ExecutorParamType<int>() { return MT_INT; };
template<> MT_Type ExecutorParamType<unsigned int>() { return MT_UINT; };
template<> MT_Type ExecutorParamType<float>() { return MT_FLOAT; };
template<> MT_Type ExecutorParamType<char>() { return MT_CHAR; };
template<> MT_Type ExecutorParamType<const std::string&>() { return MT_STRING; };

template<typename type> type fromString(const std::string& input, type defaultValue) {return defaultValue; };
template<> bool fromString<bool>(const std::string& input, bool defaultValue) { return isBool(input, defaultValue); };
template<> int fromString<int>(const std::string& input, int defaultValue) { return isInt(input, defaultValue); };
template<> unsigned int fromString<unsigned int>(const std::string& input, unsigned int defaultValue) { return isInt(input, defaultValue); };
template<> float fromString<float>(const std::string& input, float defaultValue) { return isFloat(input, defaultValue); };
template<> char fromString<char>(const std::string& input, char defaultValue) { return isInt(input, defaultValue); };
template<> const std::string& fromString<const std::string&>(const std::string& input, const std::string& defaultValue) { return isString(input, defaultValue); };

template<typename type> type getDefault(const MultiType* const defaultValues, unsigned int i) { return (type)0; };
template<> bool getDefault<bool>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getBool(); };
template<> int getDefault<int>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getInt(); };
template<> unsigned int getDefault<unsigned int>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getInt(); };
template<> float getDefault<float>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getFloat(); };
template<> char getDefault<char>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getChar(); };
template<> std::string getDefault<std::string>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getString(); };

#endif /* __EXECUTOR_FUNCTIONAL_H_ */


#define __EXECUTOR_FUNCTIONAL_CONST
#define __EXECUTOR_FUNCTIONAL_NAME(ParamCount)   Executor##ParamCount##Params
#define __EXECUTOR_FUNCTIONAL_FUNCTION_EXEC      dynamic_cast<T*>(object)->*(functionPointer)
#define __EXECUTOR_FUNCTIONAL_FUNCTION_POINTER   T::*functionPointer

#ifdef EXECUTOR_FUNCTIONAL_USE_CONST
 #undef __EXECUTOR_FUNCTIONAL_CONST
 #define __EXECUTOR_FUNCTIONAL_CONST const
 #undef __EXECUTOR_FUNCTIONAL_NAME
 #define __EXECUTOR_FUNCTIONAL_NAME(ParamCount) Executor##ParamCount##Params_const
 #undef EXECUTOR_FUNCTIONAL_USE_CONST
#endif

#ifdef EXECUTOR_FUNCTIONAL_USE_STATIC
 #ifdef EXECUTOR_FUNCTIONAL_USE_CONST
  #error you obviously do not know what you are doing !! ask the bensch
 #endif /* EXECUTOR_FUNCTIONAL_USE_CONST */

 #undef __EXECUTOR_FUNCTIONAL_FUNCTION_EXEC
 #define __EXECUTOR_FUNCTIONAL_FUNCTION_EXEC       functionPointer
 #undef __EXECUTOR_FUNCTIONAL_NAME
 #define __EXECUTOR_FUNCTIONAL_NAME(ParamCount)    Executor##ParamCount##Params_static
 #undef __EXECUTOR_FUNCTIONAL_FUNCTION_POINTER
 #define __EXECUTOR_FUNCTIONAL_FUNCTION_POINTER    *functionPointer

 #undef EXECUTOR_FUNCTIONAL_USE_STATIC
#endif /* EXECUTOR_FUNCTIONAL_USE_STATIC */

template<class T> class __EXECUTOR_FUNCTIONAL_NAME(0) : public Executor
{
private:
  void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)() __EXECUTOR_FUNCTIONAL_CONST;

public:
  __EXECUTOR_FUNCTIONAL_NAME(0) (void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)() __EXECUTOR_FUNCTIONAL_CONST )
      : Executor()
  {
    this->functorType = Executor_Objective;
    this->functionPointer = functionPointer;
  };

  virtual void operator()(BaseObject* object, const SubString& sub = SubString()) const
  {
    (__EXECUTOR_FUNCTIONAL_FUNCTION_EXEC)();
  };

  virtual Executor* clone() const {
    return new __EXECUTOR_FUNCTIONAL_NAME(0)<T>(this->functionPointer);
  };
};


template<class T, typename type0> class __EXECUTOR_FUNCTIONAL_NAME(1) : public Executor
{
private:
  void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(type0) __EXECUTOR_FUNCTIONAL_CONST;

public:
  __EXECUTOR_FUNCTIONAL_NAME(1) (void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(type0) __EXECUTOR_FUNCTIONAL_CONST)
      : Executor(ExecutorParamType<type0>())
  {
    this->functorType = Executor_Objective;
    this->functionPointer = functionPointer;
  };

  virtual void operator()(BaseObject* object, const SubString& sub = SubString()) const
  {

    /* // THE VERY COOL DEBUG
      printf("SUB[0] : %s\n", sub[0].c_str());
      printf("getDefault<type0>(this->defaultValue, 0):::: %d\n", getDefault<type0>(this->defaultValue, 0));
      printf("VALUE: %d\n", fromString<type0>(sub[0], getDefault<type0>(this->defaultValue, 0)));
    */
    (__EXECUTOR_FUNCTIONAL_FUNCTION_EXEC)(
      fromString<type0>(sub[0], getDefault<type0>(this->defaultValue, 0)) );
  };

  virtual Executor* clone() const {
    return  new __EXECUTOR_FUNCTIONAL_NAME(1)<T, type0>(this->functionPointer);
  };
};

/// DOUBLE PENETRATION
template<class T, typename type0, typename type1> class __EXECUTOR_FUNCTIONAL_NAME(2) : public Executor
{
private:
  void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(type0, type1) __EXECUTOR_FUNCTIONAL_CONST;

public:
  __EXECUTOR_FUNCTIONAL_NAME(2) (void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(type0, type1) __EXECUTOR_FUNCTIONAL_CONST)
      : Executor(ExecutorParamType<type0>(), ExecutorParamType<type1>())
  {
    this->functorType = Executor_Objective;
    this->functionPointer = functionPointer;
  };

  virtual void operator()(BaseObject* object, const SubString& sub = SubString()) const
  {
    (__EXECUTOR_FUNCTIONAL_FUNCTION_EXEC)(
      fromString<type0>(sub[0], getDefault<type0>(this->defaultValue, 0)),
      fromString<type1>(sub[1], getDefault<type1>(this->defaultValue, 1)));
  };

  virtual Executor* clone() const {
    return new __EXECUTOR_FUNCTIONAL_NAME(2)<T, type0, type1>(this->functionPointer);
  };
};



/// HACK !! THESE WILL BE RESET AGAIN !!

template<class T> Executor* createExecutor(void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)() __EXECUTOR_FUNCTIONAL_CONST)
{
  return new __EXECUTOR_FUNCTIONAL_NAME(0)<T>(functionPointer);
}
template<class T> Executor* createExecutor(void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(bool) __EXECUTOR_FUNCTIONAL_CONST)
{
  return new __EXECUTOR_FUNCTIONAL_NAME(1)<T, bool>(functionPointer);
}
template<class T> Executor* createExecutor(void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(int) __EXECUTOR_FUNCTIONAL_CONST)
{
  return new __EXECUTOR_FUNCTIONAL_NAME(1)<T, int>(functionPointer);
}
template<class T> Executor* createExecutor(void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(bool, int) __EXECUTOR_FUNCTIONAL_CONST)
{
  return new __EXECUTOR_FUNCTIONAL_NAME(2)<T, bool, int>(functionPointer);
}


#undef __EXECUTOR_FUNCTIONAL_CONST
#undef __EXECUTOR_FUNCTIONAL_NAME
#undef __EXECUTOR_FUNCTIONAL_FUNCTION_EXEC
#undef __EXECUTOR_FUNCTIONAL_FUNCTION_POINTER
